/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.viewer.emi;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.levelscraft7.recipeitemsync.client.VirtualItemIndex;
import net.levelscraft7.recipeitemsync.util.VirtualItemUtil;
import net.levelscraft7.recipeitemsync.viewer.ViewerBridge;
import net.minecraft.world.item.ItemStack;

public final class EmiViewerBridge
implements ViewerBridge {
    public static final EmiViewerBridge INSTANCE = new EmiViewerBridge();
    private EmiRegistry emiRegistry;
    private List<EmiStack> lastVirtualStacks = List.of();
    private List<EmiStack> lastVariantStacks = List.of();
    private List<ItemStack> queuedVirtual = List.of();
    private List<ItemStack> queuedVariants = List.of();

    private EmiViewerBridge() {
    }

    public static EmiViewerBridge getInstance() {
        return INSTANCE;
    }

    public void attach(EmiRegistry registry) {
        this.emiRegistry = registry;
        this.pushVirtual();
        this.pushVariants();
    }

    @Override
    public String id() {
        return "emi";
    }

    @Override
    public void updateVirtualStacks(List<ItemStack> virtualStacks) {
        this.queuedVirtual = EmiViewerBridge.copyStacks(virtualStacks);
        this.pushVirtual();
    }

    @Override
    public void updateVariantStacks(List<ItemStack> variantStacks) {
        this.queuedVariants = EmiViewerBridge.copyStacks(variantStacks);
        this.pushVariants();
    }

    @Override
    public void onDeselected() {
        this.emiRegistry = null;
        this.lastVirtualStacks = List.of();
        this.lastVariantStacks = List.of();
        this.queuedVirtual = List.of();
        this.queuedVariants = List.of();
    }

    private void pushVirtual() {
        if (this.emiRegistry == null) {
            return;
        }
        if (!this.lastVirtualStacks.isEmpty()) {
            this.emiRegistry.removeEmiStacks(this.lastVirtualStacks::contains);
        }
        this.lastVirtualStacks = EmiViewerBridge.buildEmiStacks(this.queuedVirtual);
        for (EmiStack stack : this.lastVirtualStacks) {
            this.emiRegistry.addEmiStack(stack);
        }
    }

    private void pushVariants() {
        if (this.emiRegistry == null) {
            return;
        }
        if (!this.lastVariantStacks.isEmpty()) {
            this.emiRegistry.removeEmiStacks(this.lastVariantStacks::contains);
        }
        this.lastVariantStacks = EmiViewerBridge.buildEmiStacks(this.queuedVariants);
        for (EmiStack stack : this.lastVariantStacks) {
            this.emiRegistry.addEmiStack(stack);
        }
    }

    private static List<EmiStack> buildEmiStacks(List<ItemStack> stacks) {
        ArrayList<EmiStack> emiStacks = new ArrayList<EmiStack>();
        List<String> ids = VirtualItemIndex.trackedVirtualIds();
        for (ItemStack stack : stacks) {
            String virtualId;
            if (!ids.isEmpty() && (virtualId = VirtualItemUtil.getVirtualId(stack)) != null && !ids.contains(virtualId)) continue;
            emiStacks.add(EmiStack.of((ItemStack)stack));
        }
        return List.copyOf(emiStacks);
    }

    private static List<ItemStack> copyStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> copies = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            copies.add(stack.copy());
        }
        return List.copyOf(copies);
    }
}

