/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.viewer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.levelscraft7.recipeitemsync.RecipeItemSync;
import net.levelscraft7.recipeitemsync.config.ClientConfigSheet;
import net.levelscraft7.recipeitemsync.config.ViewerPreference;
import net.levelscraft7.recipeitemsync.viewer.ViewerBridge;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.loading.FMLEnvironment;

public final class ViewerBridgeManager {
    private static final ViewerBridge NO_VIEWER = new ViewerBridge(){

        @Override
        public String id() {
            return "none";
        }

        @Override
        public void updateVirtualStacks(List<ItemStack> virtualStacks) {
        }

        @Override
        public void updateVariantStacks(List<ItemStack> variantStacks) {
        }
    };
    private static final Map<String, ViewerBridge> REGISTERED = new ConcurrentHashMap<String, ViewerBridge>();
    private static ViewerBridge active = NO_VIEWER;
    private static List<ItemStack> cachedVirtualStacks = List.of();
    private static List<ItemStack> cachedVariantStacks = List.of();

    private ViewerBridgeManager() {
    }

    public static void registerBridge(ViewerBridge bridge) {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        REGISTERED.put(bridge.id(), bridge);
        ViewerBridgeManager.refreshActiveBridge();
        ViewerBridgeManager.pushCachedToViewer();
    }

    public static void updateVirtualStacks(List<ItemStack> virtualStacks) {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        cachedVirtualStacks = ViewerBridgeManager.copyStacks(virtualStacks);
        ViewerBridgeManager.pushCachedToViewer();
    }

    public static void updateVariantStacks(List<ItemStack> variantStacks) {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        cachedVariantStacks = ViewerBridgeManager.copyStacks(variantStacks);
        ViewerBridgeManager.pushCachedToViewer();
    }

    public static void reset() {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        cachedVirtualStacks = List.of();
        cachedVariantStacks = List.of();
        if (active != null) {
            active.onDeselected();
        }
        active = NO_VIEWER;
    }

    private static void refreshActiveBridge() {
        ViewerBridge next = ViewerBridgeManager.selectPreferredBridge();
        if (next == active) {
            return;
        }
        active.onDeselected();
        active = next;
        active.onSelected();
    }

    private static void pushCachedToViewer() {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        if (Minecraft.getInstance().level == null) {
            return;
        }
        ViewerBridgeManager.refreshActiveBridge();
        active.updateVariantStacks(cachedVariantStacks);
        active.updateVirtualStacks(cachedVirtualStacks);
    }

    private static ViewerBridge selectPreferredBridge() {
        ViewerPreference preference = ClientConfigSheet.get().viewerPreference();
        List<String> preferredOrder = ViewerBridgeManager.preferenceOrder(preference);
        for (String key : preferredOrder) {
            ViewerBridge bridge = REGISTERED.get(key);
            if (bridge == null) continue;
            return bridge;
        }
        if (active != null && active != NO_VIEWER && REGISTERED.containsValue(active)) {
            return active;
        }
        if (!REGISTERED.isEmpty()) {
            String key = REGISTERED.keySet().stream().sorted().findFirst().orElse(NO_VIEWER.id());
            return REGISTERED.getOrDefault(key, NO_VIEWER);
        }
        if (!RecipeItemSync.LOGGER.isDebugEnabled()) {
            return NO_VIEWER;
        }
        RecipeItemSync.LOGGER.debug("No viewer integration registered; virtual stacks will remain in local cache only.");
        return NO_VIEWER;
    }

    private static List<String> preferenceOrder(ViewerPreference preference) {
        return switch (preference) {
            default -> throw new MatchException(null, null);
            case ViewerPreference.JEI -> List.of("jei", "rei", "emi");
            case ViewerPreference.REI -> List.of("rei", "jei", "emi");
            case ViewerPreference.EMI -> List.of("emi", "jei", "rei");
            case ViewerPreference.AUTO -> List.of("jei", "rei", "emi");
        };
    }

    private static List<ItemStack> copyStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> copies = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            copies.add(stack.copy());
        }
        return List.copyOf(copies);
    }
}

