/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.variant;

import java.util.ArrayList;
import java.util.List;
import net.levelscraft7.recipeitemsync.variant.VariantDataComponents;
import net.levelscraft7.recipeitemsync.variant.VariantDefinition;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;

public final class VariantStackBuilder {
    private VariantStackBuilder() {
    }

    public static ItemStack buildStack(VariantDefinition definition, RegistryAccess registryAccess) {
        Holder.Reference baseItem = (Holder.Reference)registryAccess.registryOrThrow(Registries.ITEM).getHolder(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)definition.baseItem())).orElseThrow(() -> new IllegalStateException("Unknown base item: " + String.valueOf(definition.baseItem())));
        ItemStack stack = new ItemStack((Holder)baseItem);
        VariantDataComponents.applyCustomModel(stack, definition.customModelData());
        VariantDataComponents.applyNameAndLore(stack, definition.displayName(), definition.lore(), definition.searchTags());
        VariantDataComponents.tagCanonicalId(stack, definition.id().toString());
        return stack;
    }

    public static String buildSubtypeKey(ItemStack stack) {
        String canonicalId = VariantDataComponents.readCanonicalId(stack);
        if (canonicalId != null) {
            return "ris:" + canonicalId;
        }
        if (stack.has(DataComponents.CUSTOM_MODEL_DATA)) {
            int customModelData = ((CustomModelData)stack.get(DataComponents.CUSTOM_MODEL_DATA)).value();
            return "cmd:" + customModelData;
        }
        return null;
    }

    public static List<ItemStack> copyStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> copies = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            copies.add(stack.copy());
        }
        return copies;
    }
}

