/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.variant;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.levelscraft7.recipeitemsync.variant.VariantDefinition;
import net.levelscraft7.recipeitemsync.variant.VariantRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public final class VariantResourceReloader
extends SimplePreparableReloadListener<List<VariantDefinition>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Supplier<RegistryAccess> registryAccessSupplier;

    public VariantResourceReloader(Supplier<RegistryAccess> registryAccessSupplier) {
        this.registryAccessSupplier = registryAccessSupplier;
    }

    protected List<VariantDefinition> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        LinkedHashMap<ResourceLocation, VariantDefinition> collected = new LinkedHashMap<ResourceLocation, VariantDefinition>();
        Map resources = resourceManager.listResources("recipe_item_sync/variants", path -> path.getPath().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation fileLocation = (ResourceLocation)entry.getKey();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Resource)entry.getValue()).open(), StandardCharsets.UTF_8));){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                VariantDefinition definition = (VariantDefinition)VariantDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(message -> new IllegalArgumentException("Failed to decode variant " + String.valueOf(fileLocation) + ": " + message));
                if (collected.putIfAbsent(definition.id(), definition) == null) continue;
                LOGGER.warn("Duplicate variant id {} detected at {}", (Object)definition.id(), (Object)fileLocation);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read variant definition {}", (Object)fileLocation, (Object)e);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Invalid variant definition at {}: {}", (Object)fileLocation, (Object)ex.getMessage());
            }
        }
        return new ArrayList<VariantDefinition>(collected.values());
    }

    protected void apply(List<VariantDefinition> variants, ResourceManager resourceManager, ProfilerFiller profiler) {
        RegistryAccess registryAccess = this.registryAccessSupplier.get();
        VariantRegistry.get().replaceDefinitions(variants, registryAccess, null);
        LOGGER.info("Loaded {} explicit variant declarations", (Object)variants.size());
    }
}

