/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.variant;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.levelscraft7.recipeitemsync.variant.RecipeVariantDiscovery;
import net.levelscraft7.recipeitemsync.variant.VariantDefinition;
import net.levelscraft7.recipeitemsync.variant.VariantStackBuilder;
import net.levelscraft7.recipeitemsync.viewer.ViewerBridgeManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

public final class VariantRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final VariantRegistry INSTANCE = new VariantRegistry();
    private final List<VariantDefinition> definitions = new CopyOnWriteArrayList<VariantDefinition>();
    private final Map<String, ItemStack> stacksBySubtype = new ConcurrentHashMap<String, ItemStack>();
    private final List<ItemStack> allStacks = new CopyOnWriteArrayList<ItemStack>();

    private VariantRegistry() {
    }

    public static VariantRegistry get() {
        return INSTANCE;
    }

    public void replaceDefinitions(List<VariantDefinition> newDefinitions, RegistryAccess registryAccess, RecipeManager recipeManager) {
        this.definitions.clear();
        this.definitions.addAll(newDefinitions);
        this.rebuildStacks(registryAccess, recipeManager);
    }

    public void rebuildStacks(RegistryAccess registryAccess, RecipeManager recipeManager) {
        this.stacksBySubtype.clear();
        ArrayList<ItemStack> nextStacks = new ArrayList<ItemStack>();
        ConcurrentHashMap.KeySetView seenKeys = ConcurrentHashMap.newKeySet();
        for (VariantDefinition definition : this.definitions) {
            try {
                ItemStack stack = VariantStackBuilder.buildStack(definition, registryAccess);
                String subtypeKey = VariantStackBuilder.buildSubtypeKey(stack);
                if (subtypeKey == null) continue;
                if (seenKeys.add(subtypeKey)) {
                    this.stacksBySubtype.put(subtypeKey, stack);
                    nextStacks.add(stack);
                    continue;
                }
                LOGGER.warn("Duplicate variant subtype {} for definition {}", (Object)subtypeKey, (Object)definition.id());
            }
            catch (Exception e) {
                LOGGER.error("Failed to bake variant {}", (Object)definition.id(), (Object)e);
            }
        }
        if (recipeManager != null) {
            List<ItemStack> discovered = RecipeVariantDiscovery.discover(recipeManager, registryAccess, seenKeys);
            for (ItemStack candidate : discovered) {
                String subtype = VariantStackBuilder.buildSubtypeKey(candidate);
                if (subtype == null || !seenKeys.add(subtype)) continue;
                this.stacksBySubtype.put(subtype, candidate);
                nextStacks.add(candidate);
            }
        }
        this.allStacks.clear();
        this.allStacks.addAll(nextStacks);
        if (FMLEnvironment.dist.isClient()) {
            ViewerBridgeManager.updateVariantStacks(VariantStackBuilder.copyStacks(this.allStacks));
        }
        LOGGER.info("Variant registry now tracking {} stacks ({} declared, {} discovered)", new Object[]{this.allStacks.size(), this.definitions.size(), this.allStacks.size() - this.definitions.size()});
    }

    public List<VariantDefinition> definitions() {
        return Collections.unmodifiableList(this.definitions);
    }

    public List<ItemStack> stacks() {
        return VariantStackBuilder.copyStacks(this.allStacks);
    }

    public ItemStack resolveSubtype(String subtypeKey) {
        ItemStack stack = this.stacksBySubtype.get(subtypeKey);
        return stack == null ? ItemStack.EMPTY : stack.copy();
    }

    public void rebuildFromServer(MinecraftServer server) {
        this.rebuildStacks((RegistryAccess)server.registryAccess(), server.getRecipeManager());
    }

    public void clear() {
        this.definitions.clear();
        this.stacksBySubtype.clear();
        this.allStacks.clear();
        if (FMLEnvironment.dist.isClient()) {
            ViewerBridgeManager.updateVariantStacks(List.of());
        }
    }
}

