/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.variant;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemLore;

public final class VariantDataComponents {
    public static final String CANONICAL_ID_KEY = "recipeitemsync:id";

    private VariantDataComponents() {
    }

    public static void tagCanonicalId(ItemStack stack, String canonicalId) {
        CustomData customData = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).update(tag -> tag.putString(CANONICAL_ID_KEY, canonicalId));
        stack.set(DataComponents.CUSTOM_DATA, (Object)customData);
    }

    public static String readCanonicalId(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null || customData == CustomData.EMPTY) {
            return null;
        }
        if (customData.contains(CANONICAL_ID_KEY)) {
            return customData.getUnsafe().getString(CANONICAL_ID_KEY);
        }
        return null;
    }

    public static void applyCustomModel(ItemStack stack, int customModelData) {
        stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(customModelData));
    }

    public static void applyNameAndLore(ItemStack stack, String displayName, List<String> lore, List<String> searchTags) {
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)displayName));
        ArrayList<MutableComponent> loreLines = new ArrayList<MutableComponent>();
        for (String line : lore) {
            loreLines.add(Component.literal((String)line));
        }
        for (String tag : searchTags) {
            loreLines.add(Component.literal((String)tag).withStyle(ChatFormatting.DARK_GRAY));
        }
        loreLines.add(Component.literal((String)displayName).withStyle(ChatFormatting.GRAY));
        stack.set(DataComponents.LORE, (Object)new ItemLore(loreLines));
    }
}

