/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.variant;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.levelscraft7.recipeitemsync.variant.VariantDataComponents;
import net.levelscraft7.recipeitemsync.variant.VariantStackBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public final class RecipeVariantDiscovery {
    private RecipeVariantDiscovery() {
    }

    public static List<ItemStack> discover(RecipeManager recipeManager, RegistryAccess registryAccess, Set<String> existingKeys) {
        ArrayList<ItemStack> discovered = new ArrayList<ItemStack>();
        HashSet<String> seen = new HashSet<String>(existingKeys);
        for (RecipeHolder holder : recipeManager.getRecipes()) {
            CustomModelData modelData;
            String subtypeKey;
            ItemStack result;
            try {
                result = holder.value().getResultItem((HolderLookup.Provider)registryAccess);
            }
            catch (Throwable t) {
                continue;
            }
            if (result == null || result.isEmpty() || (subtypeKey = VariantStackBuilder.buildSubtypeKey(result)) == null || seen.contains(subtypeKey) || (modelData = (CustomModelData)result.get(DataComponents.CUSTOM_MODEL_DATA)) == null && VariantDataComponents.readCanonicalId(result) == null) continue;
            ItemStack copy = result.copyWithCount(1);
            copy.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)"Discovered from recipes"))));
            discovered.add(copy);
            seen.add(subtypeKey);
        }
        return discovered;
    }
}

