/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemLore;

public final class VirtualItemUtil {
    public static final String DATA_KEY = "recipeitemsync:virtual_id";
    public static final String LEGACY_DATA_KEY = "recipesync:virtual_id";

    private VirtualItemUtil() {
    }

    public static ItemStack prepareVirtualStack(ItemStack original, String virtualId, String displayNameHint, List<String> tooltipLines) {
        ItemStack stack = original.copyWithCount(1);
        VirtualItemUtil.applyVirtualMetadata(stack, virtualId, displayNameHint, tooltipLines);
        return stack;
    }

    public static void applyVirtualMetadata(ItemStack stack, String virtualId, String displayNameHint, List<String> tooltipLines) {
        VirtualItemUtil.attachVirtualId(stack, virtualId);
        VirtualItemUtil.applyDisplayName(stack, virtualId, displayNameHint);
        VirtualItemUtil.applyTooltip(stack, virtualId, tooltipLines);
    }

    public static String getVirtualId(ItemStack stack) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (data.contains(DATA_KEY)) {
            return data.getUnsafe().getString(DATA_KEY);
        }
        if (data.contains(LEGACY_DATA_KEY)) {
            return data.getUnsafe().getString(LEGACY_DATA_KEY);
        }
        return null;
    }

    public static String buildSubtypeKey(ItemStack stack) {
        CustomData customData;
        String virtualId = VirtualItemUtil.getVirtualId(stack);
        if (virtualId == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder("virtual=").append(virtualId);
        CustomModelData modelData = (CustomModelData)stack.get(DataComponents.CUSTOM_MODEL_DATA);
        if (modelData != null) {
            builder.append("|cmd=").append(modelData.value());
        }
        if ((customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) != null && customData != CustomData.EMPTY) {
            builder.append("|cdata=").append(Integer.toHexString(customData.getUnsafe().hashCode()));
        }
        return builder.toString();
    }

    private static void attachVirtualId(ItemStack stack, String virtualId) {
        CustomData customData = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).update(tag -> {
            tag.putString(DATA_KEY, virtualId);
            if (!tag.contains(LEGACY_DATA_KEY)) {
                tag.putString(LEGACY_DATA_KEY, virtualId);
            }
        });
        stack.set(DataComponents.CUSTOM_DATA, (Object)customData);
    }

    private static void applyDisplayName(ItemStack stack, String virtualId, String displayNameHint) {
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            return;
        }
        String baseName = displayNameHint != null && !displayNameHint.isBlank() ? displayNameHint : VirtualItemUtil.humanizeVirtualId(virtualId);
        MutableComponent name = Component.literal((String)(baseName + " (" + virtualId + ")"));
        stack.set(DataComponents.CUSTOM_NAME, (Object)name);
    }

    private static void applyTooltip(ItemStack stack, String virtualId, List<String> tooltipLines) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        if (tooltipLines != null) {
            for (String line : tooltipLines) {
                components.add(Component.literal((String)line));
            }
        }
        components.add(Component.literal((String)virtualId).withStyle(ChatFormatting.DARK_GRAY));
        stack.set(DataComponents.LORE, (Object)new ItemLore(components));
    }

    private static String humanizeVirtualId(String virtualId) {
        ResourceLocation id = ResourceLocation.tryParse((String)virtualId);
        if (id == null) {
            return virtualId;
        }
        CharSequence[] words = id.getPath().split("[_-]");
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (word.isEmpty()) continue;
            words[i] = word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1);
        }
        return String.join((CharSequence)" ", words);
    }
}

