/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.levelscraft7.recipeitemsync.network.RecipeItemsPayload;
import net.minecraft.world.item.ItemStack;

public final class VirtualItemRegistry {
    private static final Map<String, RecipeItemsPayload.StackPayload> REGISTRY = new ConcurrentHashMap<String, RecipeItemsPayload.StackPayload>();

    private VirtualItemRegistry() {
    }

    public static void update(Collection<RecipeItemsPayload.StackPayload> payloads) {
        REGISTRY.clear();
        for (RecipeItemsPayload.StackPayload payload : payloads) {
            REGISTRY.put(payload.virtualId(), payload);
        }
    }

    public static void clear() {
        REGISTRY.clear();
    }

    public static Optional<ItemStack> resolve(String virtualId) {
        RecipeItemsPayload.StackPayload payload = REGISTRY.get(virtualId);
        if (payload == null) {
            return Optional.empty();
        }
        return Optional.of(payload.stack().copy());
    }

    public static List<String> allVirtualIds() {
        return Collections.unmodifiableList(new ArrayList<String>(REGISTRY.keySet()));
    }
}

