/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.levelscraft7.recipeitemsync.config.ClientConfigSheet;
import net.levelscraft7.recipeitemsync.network.RecipeItemsPayload;
import net.levelscraft7.recipeitemsync.util.VirtualItemUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeHolder;

public final class RecipeItemCollector {
    private RecipeItemCollector() {
    }

    public static List<RecipeItemsPayload.StackPayload> collect(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.registryAccess();
        ClientConfigSheet config = ClientConfigSheet.get();
        ArrayList<RecipeItemsPayload.StackPayload> stacks = new ArrayList<RecipeItemsPayload.StackPayload>();
        HashSet<String> seenVirtualIds = new HashSet<String>();
        for (RecipeHolder holder : server.getRecipeManager().getRecipes()) {
            String virtualId;
            ItemStack result;
            try {
                result = holder.value().getResultItem((HolderLookup.Provider)registries);
            }
            catch (Throwable t) {
                continue;
            }
            if (result == null || result.isEmpty()) {
                try {
                    result = holder.value().getToastSymbol();
                }
                catch (Throwable t) {
                    continue;
                }
            }
            if (result == null || result.isEmpty() || (virtualId = RecipeItemCollector.resolveVirtualId(result = result.copyWithCount(1), holder.id())) == null || !config.allowsVirtualId(virtualId)) continue;
            ItemStack prepared = VirtualItemUtil.prepareVirtualStack(result, virtualId, result.getHoverName().getString(), List.of());
            if (!seenVirtualIds.add(virtualId)) continue;
            stacks.add(new RecipeItemsPayload.StackPayload(virtualId, prepared, holder.id()));
        }
        for (ClientConfigSheet.ManualVirtualItem manual : config.manualVirtualItems()) {
            manual.toStack().ifPresent(stack -> {
                if (seenVirtualIds.add(manual.virtualId())) {
                    stacks.add(new RecipeItemsPayload.StackPayload(manual.virtualId(), (ItemStack)stack, ResourceLocation.fromNamespaceAndPath((String)"recipeitemsync", (String)"config")));
                }
            });
        }
        return stacks;
    }

    private static String resolveVirtualId(ItemStack stack, ResourceLocation recipeId) {
        CustomData customData;
        if (stack.has(DataComponents.CUSTOM_DATA) && (customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) != null && customData != CustomData.EMPTY && !customData.getUnsafe().isEmpty()) {
            return "recipeitemsync:" + recipeId.getNamespace() + "/" + recipeId.getPath() + "/custom_data";
        }
        if (stack.has(DataComponents.CUSTOM_MODEL_DATA)) {
            return "recipeitemsync:" + recipeId.getNamespace() + "/" + recipeId.getPath() + "/cmd";
        }
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            return "recipeitemsync:" + recipeId.getNamespace() + "/" + recipeId.getPath() + "/name";
        }
        return null;
    }

    public static boolean looksLikeVirtual(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.has(DataComponents.CUSTOM_MODEL_DATA)) {
            return true;
        }
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            return true;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return customData != null && customData != CustomData.EMPTY && !customData.getUnsafe().isEmpty();
    }
}

