/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.config;

public enum ViewerPreference {
    AUTO("auto"),
    JEI("jei"),
    REI("rei"),
    EMI("emi");

    private final String configKey;

    private ViewerPreference(String configKey) {
        this.configKey = configKey;
    }

    public String configKey() {
        return this.configKey;
    }

    public static ViewerPreference fromConfig(String raw) {
        if (raw == null || raw.isBlank()) {
            return AUTO;
        }
        String normalized = raw.trim().toLowerCase();
        for (ViewerPreference preference : ViewerPreference.values()) {
            if (!preference.configKey.equals(normalized)) continue;
            return preference;
        }
        return AUTO;
    }
}

