/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.levelscraft7.recipeitemsync.RecipeItemSync;
import net.levelscraft7.recipeitemsync.util.VirtualItemUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;

public final class ServerConfigSheet {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "recipeitemsync.json";
    private static ServerConfigSheet INSTANCE = ServerConfigSheet.buildDefaults();
    private final List<String> namespaces = new ArrayList<String>();
    private final List<ManualVirtualItem> manualVirtualItems = new ArrayList<ManualVirtualItem>();

    private ServerConfigSheet() {
    }

    public static ServerConfigSheet get() {
        return INSTANCE;
    }

    public static void bootstrapForClient(Path configRoot) {
        Path modRoot = configRoot.resolve("recipeitemsync");
        Path serverDir = modRoot.resolve("server");
        Path serverConfig = serverDir.resolve(FILE_NAME);
        Path legacyRootConfig = modRoot.resolve(FILE_NAME);
        Path legacyFlatConfig = configRoot.resolve(FILE_NAME);
        ServerConfigSheet.createMissingDirectories(serverDir);
        ServerConfigSheet.seedIfMissing(serverConfig, legacyRootConfig, legacyFlatConfig);
        INSTANCE = ServerConfigSheet.readConfig(serverConfig, true);
    }

    public static void loadForServer(Path configRoot) {
        Path serverConfig = configRoot.resolve("recipeitemsync").resolve("server").resolve(FILE_NAME);
        INSTANCE = ServerConfigSheet.readConfig(serverConfig, false);
    }

    public boolean allowsVirtualId(String virtualId) {
        if (this.namespaces.isEmpty()) {
            return true;
        }
        ResourceLocation parsed = ResourceLocation.tryParse((String)virtualId);
        String namespace = parsed != null ? parsed.getNamespace() : virtualId.split(":", 2)[0];
        for (String entry : this.namespaces) {
            String prefix;
            if (!(entry.endsWith(":*") ? namespace.equals(prefix = entry.substring(0, entry.length() - 2)) : namespace.equals(entry))) continue;
            return true;
        }
        return false;
    }

    public List<ManualVirtualItem> manualVirtualItems() {
        return Collections.unmodifiableList(this.manualVirtualItems);
    }

    public Set<Item> manualHostItems() {
        HashSet<Item> items = new HashSet<Item>();
        for (ManualVirtualItem entry : this.manualVirtualItems) {
            entry.toStack().ifPresent(stack -> items.add(stack.getItem()));
        }
        return items;
    }

    public List<ItemStack> manualStacks() {
        ArrayList stacks = new ArrayList();
        for (ManualVirtualItem entry : this.manualVirtualItems) {
            entry.toStack().ifPresent(stacks::add);
        }
        return Collections.unmodifiableList(stacks);
    }

    private static void seedIfMissing(Path target, Path legacyRootConfig, Path legacyFlatConfig) {
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        try {
            if (Files.exists(legacyRootConfig, new LinkOption[0])) {
                Files.copy(legacyRootConfig, target, new CopyOption[0]);
                RecipeItemSync.LOGGER.info("Copied legacy Recipe Item Sync config to server folder: {}", (Object)target.toAbsolutePath());
                return;
            }
            if (Files.exists(legacyFlatConfig, new LinkOption[0])) {
                Files.copy(legacyFlatConfig, target, new CopyOption[0]);
                RecipeItemSync.LOGGER.info("Copied flat Recipe Item Sync config to server folder: {}", (Object)target.toAbsolutePath());
                return;
            }
        }
        catch (IOException io) {
            RecipeItemSync.LOGGER.error("Failed to mirror old config into server folder", (Throwable)io);
        }
        ServerConfigSheet.writeTemplate(target);
    }

    private static void createMissingDirectories(Path serverDir) {
        try {
            Files.createDirectories(serverDir, new FileAttribute[0]);
        }
        catch (IOException io) {
            throw new UncheckedIOException("Unable to create config directory: " + String.valueOf(serverDir.toAbsolutePath()), io);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ServerConfigSheet readConfig(Path serverConfig, boolean allowWrite) {
        if (Files.isRegularFile(serverConfig, new LinkOption[0])) {
            try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(serverConfig));){
                reader.setLenient(true);
                ServerConfigSheet loaded = (ServerConfigSheet)GSON.fromJson(reader, ServerConfigSheet.class);
                if (loaded != null) {
                    RecipeItemSync.LOGGER.info("Loaded Recipe Item Sync config from {}", (Object)serverConfig.toAbsolutePath());
                    ServerConfigSheet serverConfigSheet = loaded;
                    return serverConfigSheet;
                }
            }
            catch (JsonParseException | IOException ex) {
                RecipeItemSync.LOGGER.error("Failed to read config {} - regenerating defaults", (Object)serverConfig, (Object)ex);
            }
        }
        if (!allowWrite) return ServerConfigSheet.buildDefaults();
        ServerConfigSheet.writeTemplate(serverConfig);
        return ServerConfigSheet.buildDefaults();
    }

    private static void writeTemplate(Path serverConfig) {
        try {
            Files.writeString(serverConfig, (CharSequence)ServerConfigSheet.defaultTemplate(), new OpenOption[0]);
            RecipeItemSync.LOGGER.info("Created Recipe Item Sync template config at {}", (Object)serverConfig.toAbsolutePath());
        }
        catch (IOException io) {
            RecipeItemSync.LOGGER.error("Unable to write template config {}", (Object)serverConfig, (Object)io);
        }
    }

    private static String defaultTemplate() {
        return "{\n  \"namespaces\": [\n    \"demo\"\n  ],\n  \"manualVirtualItems\": [\n    {\n      \"virtualId\": \"demo:load\",\n      \"hostItem\": \"minecraft:trial_key\",\n      \"customModelData\": 12345,\n      \"displayName\": \"Custom Crafts\",\n      \"tooltip\": [\"Check your Custom Recipes Here\"]\n    }\n  ]\n}\n";
    }

    private static ServerConfigSheet buildDefaults() {
        ServerConfigSheet sheet = new ServerConfigSheet();
        sheet.namespaces.add("demo");
        ManualVirtualItem sword = new ManualVirtualItem();
        sword.virtualId = "demo:customid1";
        sword.hostItem = "minecraft:trial_key";
        sword.customModelData = 12345;
        sword.displayName = "Ancient Sword";
        sword.tooltip = List.of("demo:ancient_sword");
        sheet.manualVirtualItems.add(sword);
        ManualVirtualItem axe = new ManualVirtualItem();
        axe.virtualId = "demo:customid2";
        axe.hostItem = "minecraft:trial_key";
        axe.customModelData = 12345;
        axe.displayName = "Ancient Axe";
        axe.tooltip = List.of("demo:ancient_axe");
        sheet.manualVirtualItems.add(axe);
        return sheet;
    }

    public static final class ManualVirtualItem {
        private String virtualId;
        private String hostItem;
        private Integer customModelData;
        private String displayName;
        private List<String> tooltip = List.of();

        public String virtualId() {
            return this.virtualId;
        }

        public String hostItem() {
            return this.hostItem;
        }

        public Integer customModelData() {
            return this.customModelData;
        }

        public String displayName() {
            return this.displayName;
        }

        public List<String> tooltip() {
            return this.tooltip;
        }

        public Optional<ItemStack> toStack() {
            if (this.virtualId == null || this.hostItem == null) {
                return Optional.empty();
            }
            ResourceLocation hostId = ResourceLocation.tryParse((String)this.hostItem);
            ResourceLocation virtual = ResourceLocation.tryParse((String)this.virtualId);
            if (hostId == null || virtual == null) {
                return Optional.empty();
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(hostId);
            if (item == null || item == Items.AIR) {
                return Optional.empty();
            }
            ItemStack stack = new ItemStack((ItemLike)item);
            if (this.customModelData != null) {
                stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(this.customModelData.intValue()));
            }
            VirtualItemUtil.applyVirtualMetadata(stack, virtual.toString(), this.displayName, this.tooltip);
            return Optional.of(stack);
        }
    }
}

