/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.levelscraft7.recipeitemsync.RecipeItemSync;
import net.levelscraft7.recipeitemsync.config.ViewerPreference;
import net.levelscraft7.recipeitemsync.util.VirtualItemUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;

public final class ClientConfigSheet {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "recipeitemsync.json";
    private static ClientConfigSheet INSTANCE = ClientConfigSheet.buildDefaults();
    private String viewerPreference = ViewerPreference.AUTO.configKey();
    private boolean disableIntegratedServer = false;
    private final List<String> namespaces = new ArrayList<String>();
    private final List<ManualVirtualItem> manualVirtualItems = new ArrayList<ManualVirtualItem>();

    private ClientConfigSheet() {
    }

    public static ClientConfigSheet get() {
        return INSTANCE;
    }

    public static void bootstrapClient(Path configRoot) {
        ClientConfigSheet.bootstrap(configRoot, Dist.CLIENT);
    }

    public static void loadExisting(Path configRoot) {
        Path configFile = configRoot.resolve("recipeitemsync").resolve(FILE_NAME);
        INSTANCE = ClientConfigSheet.readConfig(configFile, false);
    }

    public static void bootstrap(Path configRoot, Dist dist) {
        Path modRoot = configRoot.resolve("recipeitemsync");
        Path configFile = modRoot.resolve(FILE_NAME);
        Path legacyServerConfig = modRoot.resolve("server").resolve(FILE_NAME);
        ClientConfigSheet.createMissingDirectories(modRoot);
        ClientConfigSheet.seedIfMissing(configFile, legacyServerConfig);
        INSTANCE = ClientConfigSheet.readConfig(configFile, true);
        RecipeItemSync.LOGGER.info("Initialized Recipe Item Sync config on {}: {}", (Object)dist.name(), (Object)configFile.toAbsolutePath());
    }

    public static void seedWorldConfig(Path worldRoot, Path instanceConfigRoot) {
        Path worldConfigRoot = worldRoot.resolve("serverconfig").resolve("recipeitemsync");
        Path worldConfig = worldConfigRoot.resolve(FILE_NAME);
        Path legacyWorldConfig = worldConfigRoot.resolve("server").resolve(FILE_NAME);
        Path instanceConfig = instanceConfigRoot.resolve("recipeitemsync").resolve(FILE_NAME);
        ClientConfigSheet.createMissingDirectories(worldConfigRoot);
        if (Files.exists(worldConfig, new LinkOption[0])) {
            return;
        }
        try {
            if (Files.exists(instanceConfig, new LinkOption[0])) {
                Files.copy(instanceConfig, worldConfig, new CopyOption[0]);
                RecipeItemSync.LOGGER.info("Seeded Recipe Item Sync world config from instance copy: {}", (Object)worldConfig.toAbsolutePath());
                return;
            }
            if (Files.exists(legacyWorldConfig, new LinkOption[0])) {
                Files.copy(legacyWorldConfig, worldConfig, new CopyOption[0]);
                RecipeItemSync.LOGGER.info("Migrated legacy Recipe Item Sync world config: {}", (Object)worldConfig.toAbsolutePath());
                return;
            }
        }
        catch (IOException io) {
            RecipeItemSync.LOGGER.error("Failed to seed world config {}", (Object)worldConfig, (Object)io);
        }
        ClientConfigSheet.writeTemplate(worldConfig);
    }

    public boolean allowsVirtualId(String virtualId) {
        if (this.namespaces.isEmpty()) {
            return true;
        }
        ResourceLocation parsed = ResourceLocation.tryParse((String)virtualId);
        String namespace = parsed != null ? parsed.getNamespace() : virtualId.split(":", 2)[0];
        for (String entry : this.namespaces) {
            String prefix;
            if (!(entry.endsWith(":*") ? namespace.equals(prefix = entry.substring(0, entry.length() - 2)) : namespace.equals(entry))) continue;
            return true;
        }
        return false;
    }

    public List<ManualVirtualItem> manualVirtualItems() {
        return Collections.unmodifiableList(this.manualVirtualItems);
    }

    public ViewerPreference viewerPreference() {
        return ViewerPreference.fromConfig(this.viewerPreference);
    }

    public boolean disableIntegratedServer() {
        return this.disableIntegratedServer;
    }

    public Set<Item> manualHostItems() {
        HashSet<Item> items = new HashSet<Item>();
        for (ManualVirtualItem entry : this.manualVirtualItems) {
            entry.toStack().ifPresent(stack -> items.add(stack.getItem()));
        }
        return items;
    }

    public List<ItemStack> manualStacks() {
        ArrayList stacks = new ArrayList();
        for (ManualVirtualItem entry : this.manualVirtualItems) {
            entry.toStack().ifPresent(stacks::add);
        }
        return Collections.unmodifiableList(stacks);
    }

    private static void seedIfMissing(Path target, Path legacyServerConfig) {
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        try {
            if (Files.exists(legacyServerConfig, new LinkOption[0])) {
                Files.copy(legacyServerConfig, target, new CopyOption[0]);
                RecipeItemSync.LOGGER.info("Migrated Recipe Item Sync config from server folder: {}", (Object)target.toAbsolutePath());
                return;
            }
        }
        catch (IOException io) {
            RecipeItemSync.LOGGER.error("Failed to migrate old config into client folder", (Throwable)io);
        }
        ClientConfigSheet.writeTemplate(target);
    }

    private static void createMissingDirectories(Path configDir) {
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException io) {
            throw new UncheckedIOException("Unable to create config directory: " + String.valueOf(configDir.toAbsolutePath()), io);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClientConfigSheet readConfig(Path configFile, boolean allowWrite) {
        if (Files.isRegularFile(configFile, new LinkOption[0])) {
            try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(configFile));){
                reader.setLenient(true);
                ClientConfigSheet loaded = (ClientConfigSheet)GSON.fromJson(reader, ClientConfigSheet.class);
                if (loaded != null) {
                    RecipeItemSync.LOGGER.info("Loaded Recipe Item Sync config from {}", (Object)configFile.toAbsolutePath());
                    ClientConfigSheet clientConfigSheet = loaded;
                    return clientConfigSheet;
                }
            }
            catch (JsonParseException | IOException ex) {
                RecipeItemSync.LOGGER.error("Failed to read config {} - regenerating defaults", (Object)configFile, (Object)ex);
            }
        }
        if (!allowWrite) return new ClientConfigSheet();
        ClientConfigSheet.writeTemplate(configFile);
        return ClientConfigSheet.buildDefaults();
    }

    private static void writeTemplate(Path configFile) {
        try {
            Files.writeString(configFile, (CharSequence)ClientConfigSheet.defaultTemplate(), new OpenOption[0]);
            RecipeItemSync.LOGGER.info("Created Recipe Item Sync template config at {}", (Object)configFile.toAbsolutePath());
        }
        catch (IOException io) {
            RecipeItemSync.LOGGER.error("Unable to write template config {}", (Object)configFile, (Object)io);
        }
    }

    private static String defaultTemplate() {
        return "{\n  \"disableIntegratedServer\": false,\n  \"viewerPreference\": \"auto\",\n  \"namespaces\": [\n    \"demo\"\n  ],\n  \"manualVirtualItems\": [\n    {\n      \"virtualId\": \"demo:load\",\n      \"hostItem\": \"minecraft:trial_key\",\n      \"customModelData\": 12345,\n      \"displayName\": \"Custom Crafts\",\n      \"tooltip\": [\"Check your Custom Recipes Here\"]\n    }\n  ]\n}\n";
    }

    private static ClientConfigSheet buildDefaults() {
        ClientConfigSheet sheet = new ClientConfigSheet();
        sheet.namespaces.add("demo");
        sheet.manualVirtualItems.add(new ManualVirtualItem("demo:customid1", "minecraft:trial_key", 12345, "Ancient Sword", List.of("demo:ancient_sword")));
        sheet.manualVirtualItems.add(new ManualVirtualItem("demo:customid2", "minecraft:trial_key", 12345, "Ancient Axe", List.of("demo:ancient_axe")));
        return sheet;
    }

    public record ManualVirtualItem(String virtualId, String hostItem, Integer customModelData, String displayName, List<String> tooltip) {
        public Optional<ItemStack> toStack() {
            Item item;
            ResourceLocation location = ResourceLocation.tryParse((String)this.hostItem);
            Item item2 = item = location != null ? (Item)BuiltInRegistries.ITEM.get(location) : Items.BARRIER;
            if (item == Items.AIR) {
                return Optional.empty();
            }
            ItemStack base = new ItemStack((ItemLike)item);
            ItemStack prepared = VirtualItemUtil.prepareVirtualStack(base, this.virtualId, this.displayName, this.tooltip == null ? List.of() : this.tooltip);
            if (this.customModelData != null && this.customModelData > 0) {
                prepared.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(this.customModelData.intValue()));
            }
            return Optional.of(prepared);
        }
    }
}

