/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.client;

import java.util.ArrayList;
import java.util.List;
import net.levelscraft7.recipeitemsync.network.RecipeItemsPayload;
import net.levelscraft7.recipeitemsync.util.VirtualItemUtil;
import net.minecraft.world.item.ItemStack;

public final class VirtualItemIndex {
    private static List<RecipeItemsPayload.StackPayload> cachedPayloads = List.of();
    private static List<ItemStack> lastBuiltStacks = List.of();
    private static List<String> trackedVirtualIds = List.of();

    private VirtualItemIndex() {
    }

    public static synchronized void updatePayloads(List<RecipeItemsPayload.StackPayload> payloads) {
        cachedPayloads = List.copyOf(payloads);
        VirtualItemIndex.rebuild();
    }

    public static synchronized void clear() {
        cachedPayloads = List.of();
        lastBuiltStacks = List.of();
        trackedVirtualIds = List.of();
    }

    public static synchronized List<ItemStack> virtualStacks() {
        return VirtualItemIndex.copyStacks(lastBuiltStacks);
    }

    public static synchronized List<String> trackedVirtualIds() {
        return trackedVirtualIds;
    }

    public static boolean isVirtualStack(ItemStack stack) {
        return VirtualItemUtil.getVirtualId(stack) != null;
    }

    private static void rebuild() {
        ArrayList<ItemStack> builtStacks = new ArrayList<ItemStack>();
        ArrayList<String> virtualIds = new ArrayList<String>();
        for (RecipeItemsPayload.StackPayload payload : cachedPayloads) {
            ItemStack stack = payload.stack().copy();
            VirtualItemUtil.applyVirtualMetadata(stack, payload.virtualId(), payload.stack().getHoverName().getString(), List.of());
            builtStacks.add(stack);
            virtualIds.add(payload.virtualId());
        }
        lastBuiltStacks = List.copyOf(builtStacks);
        trackedVirtualIds = List.copyOf(virtualIds);
    }

    private static List<ItemStack> copyStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> copies = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            copies.add(stack.copy());
        }
        return List.copyOf(copies);
    }
}

