/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.client;

import java.util.List;
import net.levelscraft7.recipeitemsync.client.VirtualItemIndex;
import net.levelscraft7.recipeitemsync.client.rei.ReiRuntimeBridge;
import net.levelscraft7.recipeitemsync.network.RecipeItemsPayload;
import net.levelscraft7.recipeitemsync.util.VirtualItemRegistry;
import net.levelscraft7.recipeitemsync.viewer.ViewerBridgeManager;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public final class ClientItemCache {
    private static List<RecipeItemsPayload.StackPayload> cached = List.of();

    private ClientItemCache() {
    }

    public static List<RecipeItemsPayload.StackPayload> getCachedStacks() {
        return cached;
    }

    public static void applyServerStacks(List<RecipeItemsPayload.StackPayload> stacks) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null || minecraft.level == null || minecraft.getConnection() == null) {
            return;
        }
        cached = List.copyOf(stacks);
        VirtualItemRegistry.update(cached);
        VirtualItemIndex.updatePayloads(cached);
        ReiRuntimeBridge.ensureAttached();
        ViewerBridgeManager.updateVirtualStacks(VirtualItemIndex.virtualStacks());
        NeoForge.EVENT_BUS.post((Event)new SyncedItemsEvent(cached));
    }

    public static void clear() {
        cached = List.of();
        VirtualItemRegistry.clear();
        VirtualItemIndex.clear();
        ViewerBridgeManager.reset();
    }

    public static final class SyncedItemsEvent
    extends Event {
        private final List<RecipeItemsPayload.StackPayload> syncedStacks;

        public SyncedItemsEvent(List<RecipeItemsPayload.StackPayload> syncedStacks) {
            this.syncedStacks = syncedStacks;
        }

        public List<RecipeItemsPayload.StackPayload> getSyncedStacks() {
            return this.syncedStacks;
        }
    }
}

