/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.levelscraft7.recipeitemsync.util.VirtualItemRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public final class RecipeSyncCommand {
    private static final SuggestionProvider<CommandSourceStack> VIRTUAL_ID_SUGGESTIONS = (context, builder) -> {
        for (String id : VirtualItemRegistry.allVirtualIds()) {
            builder.suggest(id);
        }
        return builder.buildFuture();
    };

    private RecipeSyncCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"recipeitemsync").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"give").then(Commands.argument((String)"virtualId", (ArgumentType)StringArgumentType.string()).suggests(VIRTUAL_ID_SUGGESTIONS).executes(RecipeSyncCommand::giveVirtualItem))));
    }

    private static int giveVirtualItem(CommandContext<CommandSourceStack> context) {
        String virtualId = StringArgumentType.getString(context, (String)"virtualId");
        return VirtualItemRegistry.resolve(virtualId).map(stack -> RecipeSyncCommand.giveToPlayer((CommandSourceStack)context.getSource(), stack, virtualId)).orElseGet(() -> {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Unknown virtual id: " + virtualId)));
            return 0;
        });
    }

    private static int giveToPlayer(CommandSourceStack source, ItemStack stack, String virtualId) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            ItemStack copy = stack.copy();
            boolean inserted = player.getInventory().add(copy);
            if (!inserted) {
                player.drop(copy, false);
            }
            source.sendSuccess(() -> Component.literal((String)("Gave virtual item " + virtualId + " to " + player.getGameProfile().getName())), true);
            return 1;
        }
        catch (Exception ex) {
            source.sendFailure((Component)Component.literal((String)("Unable to give item: " + ex.getMessage())));
            return 0;
        }
    }
}

