/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.levelscraft7.recipeitemsync.RecipeSyncCommand;
import net.levelscraft7.recipeitemsync.client.ClientLifecycleEvents;
import net.levelscraft7.recipeitemsync.config.ClientConfigSheet;
import net.levelscraft7.recipeitemsync.network.RecipeItemSyncNetwork;
import net.levelscraft7.recipeitemsync.network.RecipeItemsPayload;
import net.levelscraft7.recipeitemsync.util.RecipeItemCollector;
import net.levelscraft7.recipeitemsync.util.VirtualItemRegistry;
import net.levelscraft7.recipeitemsync.variant.VariantRegistry;
import net.levelscraft7.recipeitemsync.variant.VariantResourceReloader;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;

@Mod(value="recipeitemsync")
public class RecipeItemSync {
    public static final String MOD_ID = "recipeitemsync";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final int LOGIN_SYNC_DELAY_TICKS = 20;
    private static final int RETRY_SYNC_DELAY_TICKS = 5;
    private final Map<UUID, Integer> pendingSyncs = new HashMap<UUID, Integer>();
    private final Set<UUID> syncedPlayers = new HashSet<UUID>();

    public RecipeItemSync(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(RecipeItemSyncNetwork::register);
        modEventBus.addListener(this::onCommonSetup);
        ClientConfigSheet.bootstrap(FMLPaths.CONFIGDIR.get(), FMLEnvironment.dist);
        if (FMLEnvironment.dist.isClient()) {
            ClientLifecycleEvents.register();
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ClientConfigSheet.bootstrap(FMLPaths.CONFIGDIR.get(), FMLEnvironment.dist));
    }

    @SubscribeEvent
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new VariantResourceReloader(() -> ((AddReloadListenerEvent)event).getRegistryAccess()));
    }

    @SubscribeEvent
    public void handlePlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.scheduleSync(player2.getServer(), player2);
        }
    }

    @SubscribeEvent
    public void handleDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            VariantRegistry.get().rebuildFromServer(event.getPlayer().getServer());
            this.scheduleSync(event.getPlayer().getServer(), event.getPlayer());
        } else if (event.getPlayerList() != null) {
            MinecraftServer server = event.getPlayerList().getServer();
            VariantRegistry.get().rebuildFromServer(server);
            for (ServerPlayer player : event.getPlayerList().getPlayers()) {
                this.scheduleSync(server, player);
            }
        }
    }

    @SubscribeEvent
    public void handleServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        if (server == null || this.pendingSyncs.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, Integer>> iterator = this.pendingSyncs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Integer> entry = iterator.next();
            int remainingTicks = entry.getValue() - 1;
            UUID playerId = entry.getKey();
            if (remainingTicks > 0) {
                entry.setValue(remainingTicks);
                continue;
            }
            ServerPlayer player = server.getPlayerList().getPlayer(playerId);
            if (player == null) {
                iterator.remove();
                continue;
            }
            if (RecipeItemSync.sendSnapshot(server, player)) {
                iterator.remove();
                this.syncedPlayers.add(playerId);
                continue;
            }
            entry.setValue(5);
        }
    }

    private void scheduleSync(MinecraftServer server, ServerPlayer player) {
        if (server == null || player == null) {
            return;
        }
        if (RecipeItemSync.shouldSkipIntegratedServer(server)) {
            return;
        }
        UUID playerId = player.getUUID();
        if (this.syncedPlayers.contains(playerId)) {
            return;
        }
        this.pendingSyncs.putIfAbsent(playerId, 20);
    }

    private static boolean sendSnapshot(MinecraftServer server, ServerPlayer player) {
        if (server == null || player == null) {
            return false;
        }
        if (player.connection == null || player.level() == null || player.level().isClientSide()) {
            return false;
        }
        if (!(player.level() instanceof ServerLevel)) {
            return false;
        }
        List<RecipeItemsPayload.StackPayload> stacks = RecipeItemCollector.collect(server);
        VirtualItemRegistry.update(stacks);
        if (!stacks.isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RecipeItemsPayload(stacks), (CustomPacketPayload[])new CustomPacketPayload[0]);
            LOGGER.debug("Sent {} custom recipe items to {}", (Object)stacks.size(), (Object)player.getGameProfile().getName());
        }
        return true;
    }

    private static boolean shouldSkipIntegratedServer(MinecraftServer server) {
        return server.isSingleplayer() && ClientConfigSheet.get().disableIntegratedServer();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        RecipeSyncCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void seedWorldConfig(ServerAboutToStartEvent event) {
        Path worldRoot = event.getServer().getWorldPath(LevelResource.ROOT);
        ClientConfigSheet.seedWorldConfig(worldRoot, FMLPaths.CONFIGDIR.get());
    }

    @SubscribeEvent
    public void handleServerStopped(ServerStoppedEvent event) {
        VariantRegistry.get().clear();
        VirtualItemRegistry.clear();
        this.pendingSyncs.clear();
        this.syncedPlayers.clear();
    }
}

