/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.type.TypeInfoBase;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VariableTypeInfo
extends TypeInfoBase {
    static final Map<TypeVariable<?>, VariableTypeInfo> CACHE = new HashMap();
    private final TypeVariable<?> raw;
    private TypeInfo mainBound;

    VariableTypeInfo(TypeVariable<?> typeVariable) {
        this.raw = typeVariable;
    }

    @Override
    public Class<?> asClass() {
        return this.getMainBound().asClass();
    }

    @Override
    public boolean shouldConvert() {
        return this.asClass() != Object.class;
    }

    public String getName() {
        return this.raw.getName();
    }

    public TypeInfo getMainBound() {
        if (this.mainBound == null) {
            Type bound = this.raw.getBounds()[0];
            this.mainBound = bound == Object.class ? NONE : TypeInfo.of(bound);
        }
        return this.mainBound;
    }

    public TypeInfo[] getBounds() {
        Type[] rawBounds = this.raw.getBounds();
        if (rawBounds.length == 1 && rawBounds[0] == Object.class) {
            return TypeInfo.EMPTY_ARRAY;
        }
        return (TypeInfo[])Arrays.stream(rawBounds).filter(t -> t != Object.class).map(TypeInfo::of).toArray(TypeInfo[]::new);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    @NotNull
    public TypeInfo consolidate(@NotNull Map<VariableTypeInfo, TypeInfo> mapping) {
        return mapping.getOrDefault(this, this);
    }
}

