/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.IdentityHashMap;
import java.util.Map;

public class TypeUtils {
    static final Map<Class<?>, TypeInfo> IMMUTABLE_CACHE = new IdentityHashMap();

    private static void cacheType(TypeInfo ... info) {
        for (TypeInfo i : info) {
            IMMUTABLE_CACHE.putIfAbsent(i.asClass(), i);
        }
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            Class clz = (Class)type;
            return clz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class) {
                Class clz = (Class)rawType;
                return clz;
            }
        } else {
            if (type instanceof GenericArrayType) {
                GenericArrayType arrType = (GenericArrayType)type;
                Type componentType = arrType.getGenericComponentType();
                return Array.newInstance(TypeUtils.getRawType(componentType), 0).getClass();
            }
            if (type instanceof TypeVariable) {
                return Object.class;
            }
            if (type instanceof WildcardType) {
                WildcardType wildcard = (WildcardType)type;
                return TypeUtils.getRawType(wildcard.getUpperBounds()[0]);
            }
        }
        return null;
    }

    public static Type getComponentType(Type type, Type fallback) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.getComponentType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arr = (GenericArrayType)type;
            return arr.getGenericComponentType();
        }
        return fallback;
    }

    static {
        TypeUtils.cacheType(TypeInfo.OBJECT_ARRAY, TypeInfo.PRIMITIVE_BOOLEAN, TypeInfo.PRIMITIVE_BOOLEAN_ARRAY, TypeInfo.PRIMITIVE_BYTE, TypeInfo.PRIMITIVE_BYTE_ARRAY, TypeInfo.PRIMITIVE_SHORT, TypeInfo.PRIMITIVE_SHORT_ARRAY, TypeInfo.PRIMITIVE_INT, TypeInfo.PRIMITIVE_INT_ARRAY, TypeInfo.PRIMITIVE_LONG, TypeInfo.PRIMITIVE_LONG_ARRAY, TypeInfo.PRIMITIVE_FLOAT, TypeInfo.PRIMITIVE_FLOAT_ARRAY, TypeInfo.PRIMITIVE_DOUBLE, TypeInfo.PRIMITIVE_DOUBLE_ARRAY, TypeInfo.PRIMITIVE_CHARACTER, TypeInfo.PRIMITIVE_CHARACTER_ARRAY);
        TypeUtils.cacheType(TypeInfo.VOID, TypeInfo.BOOLEAN, TypeInfo.BYTE, TypeInfo.SHORT, TypeInfo.INT, TypeInfo.LONG, TypeInfo.FLOAT, TypeInfo.DOUBLE, TypeInfo.CHARACTER);
        TypeUtils.cacheType(TypeInfo.NUMBER, TypeInfo.STRING, TypeInfo.STRING_ARRAY, TypeInfo.CLASS, TypeInfo.DATE, TypeInfo.CONTEXT, TypeInfo.SCRIPTABLE);
        TypeUtils.cacheType(TypeInfo.RUNNABLE, TypeInfo.RAW_CONSUMER, TypeInfo.RAW_SUPPLIER, TypeInfo.RAW_FUNCTION, TypeInfo.RAW_PREDICATE, TypeInfo.RAW_LIST, TypeInfo.RAW_SET, TypeInfo.RAW_MAP, TypeInfo.RAW_OPTIONAL, TypeInfo.RAW_ENUM_SET);
    }
}

