/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.type.VariableTypeInfo;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeConsolidator {
    private static final Map<Class<?>, Map<VariableTypeInfo, TypeInfo>> MAPPINGS = new ConcurrentHashMap();
    private static final boolean DEBUG = false;

    private TypeConsolidator() {
    }

    @NotNull
    public static Map<VariableTypeInfo, TypeInfo> getMapping(Class<?> type) {
        Map<VariableTypeInfo, TypeInfo> got = TypeConsolidator.getImpl(type);
        return got == null ? Collections.emptyMap() : got;
    }

    @NotNull
    public static TypeInfo consolidateOrNone(VariableTypeInfo variable, Map<VariableTypeInfo, TypeInfo> mapping) {
        return mapping.getOrDefault(variable, TypeInfo.NONE);
    }

    @NotNull
    public static TypeInfo[] consolidateAll(@NotNull @NotNull TypeInfo @NotNull [] original, @NotNull Map<VariableTypeInfo, TypeInfo> mapping) {
        int len = original.length;
        if (len == 0) {
            return original;
        }
        if (len == 1) {
            TypeInfo[] typeInfoArray;
            TypeInfo consolidated = original[0].consolidate(mapping);
            if (consolidated != original[0]) {
                TypeInfo[] typeInfoArray2 = new TypeInfo[1];
                typeInfoArray = typeInfoArray2;
                typeInfoArray2[0] = consolidated;
            } else {
                typeInfoArray = original;
            }
            return typeInfoArray;
        }
        TypeInfo[] transformed = original;
        for (int i = 0; i < original.length; ++i) {
            TypeInfo type = original[i];
            TypeInfo consolidated = type.consolidate(mapping);
            if (consolidated == type) continue;
            if (transformed == original) {
                transformed = (TypeInfo[])original.clone();
            }
            transformed[i] = consolidated;
        }
        return transformed;
    }

    @NotNull
    public static @NotNull List<@NotNull TypeInfo> consolidateAll(@NotNull @NotNull List<@NotNull TypeInfo> original, @NotNull Map<VariableTypeInfo, TypeInfo> mapping) {
        int len = original.size();
        if (len == 0) {
            return original;
        }
        if (len == 1) {
            TypeInfo consolidated = original.getFirst().consolidate(mapping);
            return consolidated != original.getFirst() ? List.of(consolidated) : original;
        }
        List<TypeInfo> transformed = original;
        for (int i = 0; i < len; ++i) {
            TypeInfo type = original.get(i);
            TypeInfo consolidated = type.consolidate(mapping);
            if (consolidated == type) continue;
            if (transformed == original) {
                transformed = new ArrayList<TypeInfo>(original);
            }
            transformed.set(i, consolidated);
        }
        return transformed;
    }

    @Nullable
    private static Map<VariableTypeInfo, TypeInfo> getImpl(Class<?> type) {
        if (type == null || type.isPrimitive() || type == Object.class) {
            return null;
        }
        Map<VariableTypeInfo, TypeInfo> got = MAPPINGS.get(type);
        if (got == null) {
            got = TypeConsolidator.collect(type);
            MAPPINGS.put(type, got);
        }
        return got;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static Map<VariableTypeInfo, TypeInfo> collect(Class<?> type) {
        void var8_14;
        HashMap<VariableTypeInfo, TypeInfo> mapping = new HashMap<VariableTypeInfo, TypeInfo>();
        Class<?> parent = type.getSuperclass();
        TypeConsolidator.extractSuperMapping(type.getGenericSuperclass(), mapping);
        for (Type type2 : type.getGenericInterfaces()) {
            TypeConsolidator.extractSuperMapping(type2, mapping);
        }
        Map<VariableTypeInfo, TypeInfo> superMapping = TypeConsolidator.getMapping(parent);
        Class<?>[] interfaces = type.getInterfaces();
        ArrayList<Map<VariableTypeInfo, TypeInfo>> interfaceMappings = new ArrayList<Map<VariableTypeInfo, TypeInfo>>(interfaces.length);
        Class<?>[] classArray = interfaces;
        int n = classArray.length;
        boolean bl = false;
        while (var8_14 < n) {
            Class<?> anInterface = classArray[var8_14];
            interfaceMappings.add(TypeConsolidator.getMapping(anInterface));
            ++var8_14;
        }
        if (superMapping.isEmpty() || interfaceMappings.stream().allMatch(Map::isEmpty)) {
            return TypeConsolidator.postMapping(mapping);
        }
        HashMap<VariableTypeInfo, TypeInfo> hashMap = new HashMap<VariableTypeInfo, TypeInfo>(TypeConsolidator.transformMapping(superMapping, mapping));
        for (Map map : interfaceMappings) {
            hashMap.putAll(TypeConsolidator.transformMapping(map, mapping));
        }
        hashMap.putAll(mapping);
        return TypeConsolidator.postMapping(hashMap);
    }

    private static Map<VariableTypeInfo, TypeInfo> transformMapping(Map<VariableTypeInfo, TypeInfo> mapping, Map<VariableTypeInfo, TypeInfo> transformer) {
        if (mapping.isEmpty()) {
            return Map.of();
        }
        if (mapping.size() == 1) {
            Map.Entry<VariableTypeInfo, TypeInfo> entry = mapping.entrySet().iterator().next();
            return Map.of(entry.getKey(), entry.getValue().consolidate(transformer));
        }
        HashMap<VariableTypeInfo, TypeInfo> transformed = new HashMap<VariableTypeInfo, TypeInfo>(mapping);
        for (Map.Entry<VariableTypeInfo, TypeInfo> entry : transformed.entrySet()) {
            entry.setValue(entry.getValue().consolidate(transformer));
        }
        return transformed;
    }

    private static void extractSuperMapping(Type superType, Map<VariableTypeInfo, TypeInfo> pushTo) {
        ParameterizedType parameterized;
        Type type;
        if (superType instanceof ParameterizedType && (type = (parameterized = (ParameterizedType)superType).getRawType()) instanceof Class) {
            Class parent = (Class)type;
            TypeVariable<Class<T>>[] params = parent.getTypeParameters();
            Type[] args = parameterized.getActualTypeArguments();
            for (int i = 0; i < args.length; ++i) {
                pushTo.put(TypeInfo.of(params[i]), TypeInfo.of(args[i]));
            }
        }
    }

    private static Map<VariableTypeInfo, TypeInfo> postMapping(Map<VariableTypeInfo, TypeInfo> mapping) {
        switch (mapping.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<VariableTypeInfo, TypeInfo> entry = mapping.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(mapping);
    }
}

