/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.type.TypeInfo;

public class CustomFunction
extends BaseFunction {
    private final String functionName;
    private final Func func;
    private final TypeInfo[] argTypes;

    public CustomFunction(String functionName, Func func, TypeInfo[] argTypes) {
        this.functionName = functionName;
        this.func = func;
        this.argTypes = argTypes.length == 0 ? TypeInfo.EMPTY_ARRAY : argTypes;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object[] origArgs = args;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Object coerced = cx.jsToJava(arg, this.argTypes[i]);
            if (coerced == arg) continue;
            if (origArgs == args) {
                args = (Object[])args.clone();
            }
            args[i] = coerced;
        }
        return this.func.call(cx, args);
    }

    @FunctionalInterface
    public static interface Func {
        public Object call(Context var1, Object[] var2);
    }

    @FunctionalInterface
    public static interface NoArgFunc
    extends Func {
        public Object call(Context var1);

        @Override
        default public Object call(Context cx, Object[] args) {
            return this.call(cx);
        }
    }
}

