/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.pokerus;

import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.pokerus.Pokerus;
import us.timinc.mc.cobblemon.pokerus.extension.PokemonExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ%\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u000f\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lus/timinc/mc/cobblemon/pokerus/PokerusManager;", "", "<init>", "()V", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "party", "", "affectTeamPostBattle", "(Ljava/util/List;)V", "tryInfectRandomPartyMember", "", "index", "trySpreadFromIndex", "(ILjava/util/List;)V", "tickDay", "common"})
@SourceDebugExtension(value={"SMAP\nPokerusManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokerusManager.kt\nus/timinc/mc/cobblemon/pokerus/PokerusManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n774#2:72\n865#2,2:73\n1563#2:75\n1634#2,3:76\n1761#2,3:79\n774#2:82\n865#2,2:83\n*S KotlinDebug\n*F\n+ 1 PokerusManager.kt\nus/timinc/mc/cobblemon/pokerus/PokerusManager\n*L\n20#1:72\n20#1:73,2\n21#1:75\n21#1:76,3\n30#1:79,3\n35#1:82\n35#1:83,2\n*E\n"})
public final class PokerusManager {
    @NotNull
    public static final PokerusManager INSTANCE = new PokerusManager();

    private PokerusManager() {
    }

    /*
     * WARNING - void declaration
     */
    public final void affectTeamPostBattle(@NotNull List<? extends Pokemon> party) {
        void $this$mapTo$iv$iv;
        IndexedValue it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(party, (String)"party");
        if (party.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = CollectionsKt.withIndex((Iterable)party);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            if (!PokemonExtensionsKt.hasPokerus((Pokemon)it.getValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getIndex());
        }
        List infectedIndexes = (List)destination$iv$iv;
        this.tryInfectRandomPartyMember(party);
        Iterator iterator = infectedIndexes.iterator();
        while (iterator.hasNext()) {
            int index = ((Number)iterator.next()).intValue();
            this.trySpreadFromIndex(index, party);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void tryInfectRandomPartyMember(List<? extends Pokemon> party) {
        void $this$filterTo$iv$iv;
        Object it;
        boolean bl;
        block7: {
            Iterable $this$any$iv = party;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Pokemon)element$iv;
                    boolean bl2 = false;
                    if (!PokemonExtensionsKt.hasEverHadPokerus(it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl && ((Pokerus.PokerusConfig)Pokerus.INSTANCE.getConfig()).getOnlyInfectNewIfNobodyOnTeamHas()) {
            return;
        }
        int chance = Random.Default.nextInt(((Pokerus.PokerusConfig)Pokerus.INSTANCE.getConfig()).getWildInfectionChanceDenominator());
        if (chance >= ((Pokerus.PokerusConfig)Pokerus.INSTANCE.getConfig()).getWildInfectionChangeNumerator()) {
            return;
        }
        Iterable $this$filter$iv = (Iterable)CollectionsKt.getIndices((Collection)party);
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it2 = ((Number)element$iv$iv).intValue();
            boolean bl3 = false;
            if (!PokemonExtensionsKt.neverHadPokerus(party.get(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List eligibleIndexes = (List)destination$iv$iv;
        if (eligibleIndexes.isEmpty()) {
            return;
        }
        int targetIndex = ((Number)CollectionsKt.random((Collection)eligibleIndexes, (Random)((Random)Random.Default))).intValue();
        PokemonExtensionsKt.infectWithPokerus$default(party.get(targetIndex), null, 1, null);
    }

    private final void trySpreadFromIndex(int index, List<? extends Pokemon> party) {
        Object object = new Integer[]{-1, 1};
        List adjacentOffsets = CollectionsKt.listOf((Object[])object);
        object = adjacentOffsets.iterator();
        while (object.hasNext()) {
            int offset = ((Number)object.next()).intValue();
            int targetIndex = index + offset;
            boolean bl = 0 <= targetIndex ? targetIndex < ((Collection)party).size() : false;
            if (!bl) continue;
            Pokemon target = party.get(targetIndex);
            int spreadRoll = Random.Default.nextInt(((Pokerus.PokerusConfig)Pokerus.INSTANCE.getConfig()).getChanceToSpread());
            if (!PokemonExtensionsKt.neverHadPokerus(target) || spreadRoll != 0) continue;
            Pair<Integer, Integer> pair = PokemonExtensionsKt.getPokerus(party.get(index));
            if (pair == null) continue;
            PokemonExtensionsKt.infectWithPokerus(target, pair);
        }
    }

    public final void tickDay(@NotNull List<? extends Pokemon> party) {
        Intrinsics.checkNotNullParameter(party, (String)"party");
        for (Pokemon pokemon : party) {
            Float lastCheckedDay = Pokerus.PokemonProperties.INSTANCE.getLAST_CHECKED_DAY().getValue(pokemon);
            ServerPlayer serverPlayer = pokemon.getOwnerPlayer();
            if (serverPlayer == null || (serverPlayer = serverPlayer.getStats()) == null) {
                continue;
            }
            int currentPlayTime = serverPlayer.getValue(Stats.CUSTOM.get((Object)Stats.PLAY_TIME));
            int currentPlayDay = (int)Math.floor((double)currentPlayTime / 2400.0) + 1;
            Pokerus.PokemonProperties.INSTANCE.getLAST_CHECKED_DAY().pokemonApplicator(pokemon, (float)currentPlayDay);
            if (lastCheckedDay == null || (float)currentPlayDay <= lastCheckedDay.floatValue()) continue;
            PokemonExtensionsKt.tickPokerus(pokemon);
        }
    }
}

