/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.splashes;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class WaterSplashParticle
extends TextureSheetParticle {
    protected final SpriteSet provider;
    private final float width;
    private final float height;
    private final Color color;
    private final float unit;
    protected boolean colored = true;

    WaterSplashParticle(ClientLevel clientWorld, double x, double y, double z, float width, float height, SpriteSet provider) {
        super(clientWorld, x, y, z);
        this.gravity = 0.0f;
        this.lifetime = 18;
        this.width = width;
        this.height = height;
        this.provider = provider;
        this.setSpriteFromAge(provider);
        this.color = new Color(BiomeColors.getAverageWaterColor((BlockAndTintGetter)clientWorld, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z)));
        this.unit = 2.0f / (float)Minecraft.getInstance().particleEngine.textureAtlas.getWidth();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.provider);
        if (!this.level.getFluidState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).is(FluidTags.WATER)) {
            this.remove();
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 vec3d = camera.getPosition();
        float f = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - vec3d.x());
        float g = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - vec3d.y());
        float h = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - vec3d.z());
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
        float ageDelta = Mth.lerp((float)tickDelta, (float)(this.age - 1), (float)this.age);
        float progress = ageDelta / (float)this.lifetime;
        float scale = this.width * (0.8f + 0.2f * progress);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f2 = vector3fs[i];
            vector3f2.mul(scale);
            vector3f2.add(f, g, h);
        }
        float l = this.getU0() + this.unit;
        float m = this.getU1() - this.unit;
        float n = this.getV0();
        float o = this.getV1();
        int light = this.getLightColor(tickDelta);
        int color = this.colored ? this.color.getRGB() : Color.white.getRGB();
        this.renderSide(vertexConsumer, vector3fs, 0, 1, this.height, l, m, n, o, light, color);
        this.renderSide(vertexConsumer, vector3fs, 1, 2, this.height, l, m, n, o, light, color);
        this.renderSide(vertexConsumer, vector3fs, 2, 3, this.height, l, m, n, o, light, color);
        this.renderSide(vertexConsumer, vector3fs, 3, 0, this.height, l, m, n, o, light, color);
    }

    private void renderSide(VertexConsumer vertexConsumer, Vector3f[] vector3fs, int a, int b, float height, float l, float m, float n, float o, int light, int color) {
        vertexConsumer.addVertex(vector3fs[a].x(), vector3fs[a].y(), vector3fs[a].z()).setUv(l, o).setColor(color).setLight(light);
        vertexConsumer.addVertex(vector3fs[b].x(), vector3fs[b].y(), vector3fs[b].z()).setUv(m, o).setColor(color).setLight(light);
        vertexConsumer.addVertex(vector3fs[b].x(), vector3fs[b].y() + height, vector3fs[b].z()).setUv(m, n).setColor(color).setLight(light);
        vertexConsumer.addVertex(vector3fs[a].x(), vector3fs[a].y() + height, vector3fs[a].z()).setUv(l, n).setColor(color).setLight(light);
        vertexConsumer.addVertex(vector3fs[b].x(), vector3fs[b].y(), vector3fs[b].z()).setUv(m, o).setColor(color).setLight(light);
        vertexConsumer.addVertex(vector3fs[a].x(), vector3fs[a].y(), vector3fs[a].z()).setUv(l, o).setColor(color).setLight(light);
        vertexConsumer.addVertex(vector3fs[a].x(), vector3fs[a].y() + height, vector3fs[a].z()).setUv(l, n).setColor(color).setLight(light);
        vertexConsumer.addVertex(vector3fs[b].x(), vector3fs[b].y() + height, vector3fs[b].z()).setUv(m, n).setColor(color).setLight(light);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double x, double y, double z, double g, double h, double i) {
            return new WaterSplashParticle(clientWorld, x, y, z, (float)g, (float)h, this.provider);
        }
    }
}

