/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.neoforge;

import com.emperdog.releaserewards.services.ReleaseRewardsConfig;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="releaserewards", bus=EventBusSubscriber.Bus.MOD)
public class NeoForgeReleaseRewardsConfig
implements ReleaseRewardsConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.IntValue MAX_PREEVO_SEARCH_DEPTH = BUILDER.comment(new String[]{"Max search depth for EvolutionStageCondition finding Pre-Evolutions of species.", "Prevents crashes from recursive Pre-Evolutions.", "Why? why anyone would do that is beyond me, but it exists somewhere.", "If this activates, the Species will be considered Unevolving"}).defineInRange("maxPreEvoSearchDepth", 10, 0, Integer.MAX_VALUE);
    public static final ModConfigSpec.IntValue MAX_EVO_SEARCH_DEPTH = BUILDER.comment(new String[]{"Max search depth for EvolutionStageCondition finding Evolutions of species.", "Prevents crashes from recursive Evolutions.", "Why? Some addons implement Form Changes for species such as Deoxys, as Evolutions into an alternate Form.", "If this activates, the Species will be considered Unevolving"}).defineInRange("maxEvoSearchDepth", 10, 0, Integer.MAX_VALUE);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static int maxPreEvoSearchDepth;
    public static int maxEvoSearchDepth;

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        NeoForgeReleaseRewardsConfig.assignConfigValues();
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Reloading event) {
        NeoForgeReleaseRewardsConfig.assignConfigValues();
    }

    private static void assignConfigValues() {
        maxPreEvoSearchDepth = (Integer)MAX_PREEVO_SEARCH_DEPTH.get();
        maxEvoSearchDepth = (Integer)MAX_EVO_SEARCH_DEPTH.get();
    }

    @Override
    public int getMaxPreEvoSearchDepth() {
        return maxPreEvoSearchDepth;
    }

    @Override
    public int getMaxEvoSearchDepth() {
        return maxEvoSearchDepth;
    }
}

