/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.modifiers;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.modifiers.ModLootFunctions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class LevelBonusModifier
extends LootItemConditionalFunction {
    private final int startingAtLevel;
    private final int levelsPerExtra;
    private final int count;
    public static final MapCodec<LevelBonusModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LevelBonusModifier.commonFields((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.INT.optionalFieldOf("starting_at", (Object)0).forGetter(e -> e.startingAtLevel), (App)Codec.INT.fieldOf("levels_per").forGetter(e -> e.levelsPerExtra), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(e -> e.count))).apply((Applicative)inst, LevelBonusModifier::new));

    public LevelBonusModifier(List<LootItemCondition> conditions, int startingAtLevel, int levelsPerExtra, int count) {
        super(conditions);
        this.startingAtLevel = startingAtLevel;
        this.levelsPerExtra = levelsPerExtra;
        this.count = count;
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack stack, LootContext context) {
        int bonus;
        int pokemonLevel = ((Pokemon)context.getParam(ModLootContextParams.POKEMON)).getLevel();
        boolean withinRange = pokemonLevel - this.startingAtLevel >= 0;
        int n = bonus = withinRange ? (pokemonLevel - this.startingAtLevel) / this.levelsPerExtra : 0;
        if (bonus > 0) {
            stack.setCount(stack.getCount() + bonus * this.count);
        }
        return stack;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return ModLootFunctions.LEVEL_BONUS;
    }
}

