/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.entry;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.EnumPokemonStats;
import com.emperdog.releaserewards.ReleaseRewards;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.ReleaseUtils;
import com.emperdog.releaserewards.loot.entry.ModLootEntries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.SimpleMapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public class StatsWeightedItemEntry
extends LootPoolSingletonContainer {
    private final Map<EnumPokemonStats, ItemStack> options;
    private final String subset;
    private static int addedWeight = 0;
    public static final MapCodec<StatsWeightedItemEntry> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)StatsWeightedItemEntry.statMapCodec(ItemStack.CODEC).codec().fieldOf("items").forGetter(e -> e.options), (App)Codec.STRING.fieldOf("subset").forGetter(e -> e.subset), (App)Codec.INT.optionalFieldOf("added_weight", (Object)0).forGetter(e -> addedWeight)).and(StatsWeightedItemEntry.singletonFields((RecordCodecBuilder.Instance)inst)).apply((Applicative)inst, StatsWeightedItemEntry::new));

    public static <T> SimpleMapCodec<EnumPokemonStats, T> statMapCodec(Codec<T> elementCodec) {
        return Codec.simpleMap(EnumPokemonStats.CODEC, elementCodec, (Keyable)Keyable.forStrings(() -> Arrays.stream(EnumPokemonStats.values()).map(EnumPokemonStats::getSerializedName)));
    }

    public StatsWeightedItemEntry(Map<EnumPokemonStats, ItemStack> options, String subset, int addedWeight, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.options = options;
        this.subset = subset;
        StatsWeightedItemEntry.addedWeight = addedWeight;
    }

    public static ItemStack pickStatValueWeightedLoot(Map<EnumPokemonStats, ItemStack> options, Map<Stat, Integer> stats, LootContext context) {
        RandomSource random = context.getRandom();
        MutableInt totalWeight = new MutableInt();
        ArrayList stacks = new ArrayList();
        stats.forEach((stat, value) -> {
            ItemStack current = (ItemStack)options.get((Object)EnumPokemonStats.valueOf(stat.getShowdownId().toUpperCase()));
            stacks.add(current);
            totalWeight.add(value + addedWeight);
        });
        int size = stacks.size();
        if (size == 1) {
            return (ItemStack)stacks.getFirst();
        }
        if (totalWeight.intValue() != 0 && size != 0) {
            int weight = random.nextInt(totalWeight.intValue());
            for (EnumPokemonStats stat2 : options.keySet()) {
                if ((weight -= stats.get(Stats.Companion.getStat(stat2.getSerializedName())) + addedWeight) >= 0) continue;
                return options.get((Object)stat2);
            }
        }
        ReleaseRewards.LOGGER.warn("A StatsWeightedItemEntry '{}' was invalid, returning Empty Stack.", (Object)options.toString());
        return ItemStack.EMPTY;
    }

    public Map<EnumPokemonStats, ItemStack> getOptions() {
        return this.options;
    }

    protected void createItemStack(Consumer<ItemStack> consumer, LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        Map<Stat, Integer> stats = ReleaseUtils.getStatSubset(this.subset, pokemon);
        consumer.accept(StatsWeightedItemEntry.pickStatValueWeightedLoot(this.options, stats, context));
    }

    @NotNull
    public LootPoolEntryType getType() {
        return ModLootEntries.STATS_WEIGHTED;
    }
}

