/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.entry;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.CobblemonHelperKt;
import com.emperdog.releaserewards.ReleaseRewards;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.entry.ModLootEntries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import kotlin.ranges.IntRange;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class PokemonDropsEntry
extends LootPoolSingletonContainer {
    private final int minAmount;
    private final int maxAmount;
    public static final MapCodec<PokemonDropsEntry> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.optionalFieldOf("min_amount", (Object)0).forGetter(e -> e.minAmount), (App)Codec.INT.optionalFieldOf("max_amount", (Object)0).forGetter(e -> e.maxAmount)).and(PokemonDropsEntry.singletonFields((RecordCodecBuilder.Instance)inst)).apply((Applicative)inst, PokemonDropsEntry::new));

    protected PokemonDropsEntry(int minAmount, int maxAmount, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.minAmount = minAmount;
        this.maxAmount = Math.max(maxAmount, minAmount);
    }

    protected void createItemStack(@NotNull Consumer<ItemStack> consumer, @NotNull LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        Player player = (Player)context.getParam(LootContextParams.LAST_DAMAGE_PLAYER);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List drops = this.maxAmount > 0 ? pokemon.getForm().getDrops().getDrops(new IntRange(this.minAmount, this.maxAmount), pokemon) : CobblemonHelperKt.Companion.getPokemonDrops(pokemon);
            drops.forEach(drop -> drop.drop(null, serverPlayer.serverLevel(), serverPlayer.position(), serverPlayer));
        } else {
            ReleaseRewards.LOGGER.warn("Player '{}' is not instanceof ServerPlayer, PokemonDropsEntry for {} cannot be created.", (Object)player.getName(), (Object)pokemon.getSpecies().resourceIdentifier);
        }
    }

    @NotNull
    public LootPoolEntryType getType() {
        return ModLootEntries.POKEMON_DROPS;
    }
}

