/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record TeraTypeCondition(List<TeraType> teraTypes, boolean invert) implements LootItemCondition
{
    public static final MapCodec<TeraTypeCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)TeraType.getBY_IDENTIFIER_CODEC().listOf().fieldOf("types").forGetter(TeraTypeCondition::teraTypes), (App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(TeraTypeCondition::invert)).apply((Applicative)inst, TeraTypeCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return ModLootConditions.TERA_TYPE;
    }

    public boolean test(LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        return this.teraTypes.contains(pokemon.getTeraType()) != this.invert;
    }
}

