/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.ReleaseUtils;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record PokemonValueRangeCondition(int min, int max, String valueType) implements LootItemCondition
{
    public static final MapCodec<PokemonValueRangeCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("min").fieldOf("range").forGetter(PokemonValueRangeCondition::min), (App)Codec.INT.fieldOf("max").fieldOf("range").forGetter(PokemonValueRangeCondition::max), (App)Codec.STRING.fieldOf("value_type").forGetter(PokemonValueRangeCondition::valueType)).apply((Applicative)inst, PokemonValueRangeCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return ModLootConditions.POKEMON_VALUE_RANGE;
    }

    public boolean test(@NotNull LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        String[] valueDetails = this.valueType.split("_");
        double value = this.getValue(pokemon, valueDetails[0], valueDetails.length > 1 ? valueDetails[1] : "");
        return value >= (double)this.min && value <= (double)this.max;
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(ModLootContextParams.POKEMON);
    }

    public double getValue(Pokemon pokemon, String valueType, String suffix) {
        boolean forStat = false;
        double value = switch (valueType) {
            case "level" -> pokemon.getLevel();
            case "friendship" -> pokemon.getFriendship();
            default -> {
                if (valueType.endsWith("stat") || valueType.endsWith("iv") || valueType.endsWith("ev")) {
                    forStat = true;
                }
                yield 0.0;
            }
        };
        if (!forStat) {
            return value;
        }
        return switch (Objects.requireNonNull(ReleaseUtils.getStatByAlias(valueType)).getShowdownId() + "_" + suffix) {
            case "hp_stat" -> pokemon.getMaxHealth();
            case "atk_stat" -> pokemon.getAttack();
            case "def_stat" -> pokemon.getDefence();
            case "spa_stat" -> pokemon.getSpecialAttack();
            case "spd_stat" -> pokemon.getSpecialDefence();
            case "spe_stat" -> pokemon.getSpeed();
            case "hp_ev" -> pokemon.getEvs().get((Stat)Stats.HP).intValue();
            case "atk_ev" -> pokemon.getEvs().get((Stat)Stats.ATTACK).intValue();
            case "def_ev" -> pokemon.getEvs().get((Stat)Stats.DEFENCE).intValue();
            case "spa_ev" -> pokemon.getEvs().get((Stat)Stats.SPECIAL_ATTACK).intValue();
            case "spd_ev" -> pokemon.getEvs().get((Stat)Stats.SPECIAL_DEFENCE).intValue();
            case "spe_ev" -> pokemon.getEvs().get((Stat)Stats.SPEED).intValue();
            case "hp_iv" -> pokemon.getIvs().get((Stat)Stats.HP).intValue();
            case "atk_iv" -> pokemon.getIvs().get((Stat)Stats.ATTACK).intValue();
            case "def_iv" -> pokemon.getIvs().get((Stat)Stats.DEFENCE).intValue();
            case "spa_iv" -> pokemon.getIvs().get((Stat)Stats.SPECIAL_ATTACK).intValue();
            case "spd_iv" -> pokemon.getIvs().get((Stat)Stats.SPECIAL_DEFENCE).intValue();
            case "spe_iv" -> pokemon.getIvs().get((Stat)Stats.SPEED).intValue();
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(ReleaseUtils.getStatByAlias(valueType)));
        };
    }
}

