/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record PokemonTypeCondition(ElementalType type, boolean invert) implements LootItemCondition
{
    public static final MapCodec<PokemonTypeCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ElementalType.getBY_STRING_CODEC().fieldOf("type").forGetter(PokemonTypeCondition::type), (App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(PokemonTypeCondition::invert)).apply((Applicative)inst, PokemonTypeCondition::new));

    public LootItemConditionType getType() {
        return ModLootConditions.POKEMON_TYPE;
    }

    public boolean test(LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        boolean pass = false;
        for (ElementalType pokemonType : pokemon.getTypes()) {
            if (pokemonType != this.type) continue;
            pass = true;
            break;
        }
        return pass != this.invert;
    }
}

