/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonPropertyExtractor;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record PokemonPropertiesCondition(String propertiesString, boolean invert) implements LootItemCondition
{
    public static final MapCodec<PokemonPropertiesCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.fieldOf("properties").forGetter(PokemonPropertiesCondition::propertiesString), (App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(PokemonPropertiesCondition::invert)).apply((Applicative)inst, PokemonPropertiesCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return ModLootConditions.POKEMON_PROPERTIES;
    }

    public boolean test(LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        PokemonProperties pokemonProperties = pokemon.createPokemonProperties(PokemonPropertyExtractor.ALL);
        PokemonProperties argumentProperties = PokemonProperties.Companion.parse(this.propertiesString);
        return argumentProperties.isSubSetOf(pokemonProperties) != this.invert;
    }
}

