/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record PokemonLabelCondition(List<String> labels, boolean invert) implements LootItemCondition
{
    public static final MapCodec<PokemonLabelCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.listOf().fieldOf("labels").forGetter(PokemonLabelCondition::labels), (App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(PokemonLabelCondition::invert)).apply((Applicative)inst, PokemonLabelCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return ModLootConditions.POKEMON_LABEL;
    }

    public boolean test(@NotNull LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        boolean hasLabel = false;
        for (String label : this.labels) {
            if (!pokemon.hasLabels(new String[]{label})) continue;
            hasLabel = true;
            break;
        }
        return hasLabel != this.invert;
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(ModLootContextParams.POKEMON);
    }
}

