/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.ReleaseUtils;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record NatureInfluenceCondition(String influencedStat, boolean positive) implements LootItemCondition
{
    public static final MapCodec<NatureInfluenceCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.fieldOf("stat").forGetter(NatureInfluenceCondition::influencedStat), (App)Codec.BOOL.optionalFieldOf("positive", (Object)true).forGetter(NatureInfluenceCondition::positive)).apply((Applicative)inst, NatureInfluenceCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return ModLootConditions.NATURE_INFLUENCE;
    }

    public boolean test(LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        Stat influenced = ReleaseUtils.getStatByAlias(this.influencedStat);
        Nature nature = pokemon.getNature();
        if (Objects.isNull(influenced) && Objects.isNull(nature.getIncreasedStat()) && Objects.isNull(nature.getDecreasedStat())) {
            return true;
        }
        return this.positive ? nature.getIncreasedStat() == influenced : nature.getDecreasedStat() == influenced;
    }
}

