/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.ReleaseRewards;
import com.emperdog.releaserewards.data.MovePredicate;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.ReleaseUtils;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record MovePredicateCondition(MovePredicate move, String powerCalc, String accuracyCalc, String priorityCalc, String maxppCalc) implements LootItemCondition
{
    public static final MapCodec<MovePredicateCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)MovePredicate.CODEC.fieldOf("move_predicate").forGetter(MovePredicateCondition::move), (App)Codec.STRING.optionalFieldOf("power_calc", (Object)"=").forGetter(MovePredicateCondition::powerCalc), (App)Codec.STRING.optionalFieldOf("accuracy_calc", (Object)"=").forGetter(MovePredicateCondition::accuracyCalc), (App)Codec.STRING.optionalFieldOf("priority_calc", (Object)"=").forGetter(MovePredicateCondition::priorityCalc), (App)Codec.STRING.optionalFieldOf("max_pp_calc", (Object)"=").forGetter(MovePredicateCondition::maxppCalc)).apply((Applicative)inst, MovePredicateCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return ModLootConditions.MOVE_PREDICATE;
    }

    public boolean test(LootContext context) {
        List<Object> moves;
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        Stream<Object> pokemonMoves = pokemon.getAllAccessibleMoves().stream();
        if (!this.powerCalc.isEmpty()) {
            pokemonMoves = pokemonMoves.filter(knownMove -> this.testPropertyCalc(this.powerCalc, knownMove.getPower(), this.move.getPower()));
        }
        if (!this.accuracyCalc.isEmpty()) {
            pokemonMoves = pokemonMoves.filter(knownMove -> this.testPropertyCalc(this.accuracyCalc, knownMove.getAccuracy(), this.move.getAccuracy()));
        }
        if (!Objects.isNull(this.move.getDamageCategory())) {
            pokemonMoves = pokemonMoves.filter(knownMove -> knownMove.getDamageCategory() == this.move.getDamageCategory());
        }
        if (!Objects.isNull(this.move.getTarget())) {
            pokemonMoves = pokemonMoves.filter(knownMove -> knownMove.getTarget().equals((Object)this.move.getTarget()));
        }
        if (this.move.getType() != ReleaseUtils.EMPTY_TYPE) {
            pokemonMoves = pokemonMoves.filter(knownMove -> knownMove.getElementalType() == this.move.getType());
        }
        if (this.move.getPriority() > -99) {
            pokemonMoves = pokemonMoves.filter(knownMove -> this.testPropertyCalc(this.priorityCalc, knownMove.getPriority(), this.move.getPriority()));
        }
        if (this.move.getMaxpp() > 0) {
            pokemonMoves = pokemonMoves.filter(knownMove -> this.testPropertyCalc(this.maxppCalc, knownMove.getPp(), this.move.getMaxpp()));
        }
        return !(moves = pokemonMoves.toList()).isEmpty();
    }

    public boolean testPropertyCalc(String calcType, double knownMoveValue, double moveValue) {
        if (!calcType.isEmpty()) {
            switch (calcType) {
                case "greater": 
                case "greater_than": 
                case ">": {
                    return knownMoveValue > moveValue;
                }
                case "less": 
                case "less_than": 
                case "<": {
                    return knownMoveValue < moveValue;
                }
                case "equal": 
                case "equals": 
                case "=": 
                case "==": {
                    return knownMoveValue == moveValue;
                }
            }
            ReleaseRewards.LOGGER.warn("MovePredicateCondition with move '{}' has invalid calc type '{}'", (Object)this.move, (Object)calcType);
        }
        return false;
    }
}

