/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record KnowsMoveCondition(List<String> moves, boolean invert) implements LootItemCondition
{
    public static MapCodec<KnowsMoveCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.listOf().fieldOf("moves").forGetter(KnowsMoveCondition::moves), (App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(KnowsMoveCondition::invert)).apply((Applicative)inst, KnowsMoveCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return ModLootConditions.KNOWS_MOVE;
    }

    public boolean test(LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        Set knownMoves = pokemon.getAllAccessibleMoves();
        for (String move : this.moves) {
            if (knownMoves.contains(Moves.getByName((String)move)) == this.invert) continue;
            return true;
        }
        return false;
    }
}

