/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.ReleaseUtils;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record HiddenAbilityCondition(boolean hiddenAbility) implements LootItemCondition
{
    public static final MapCodec<HiddenAbilityCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.BOOL.fieldOf("has_hidden_ability").forGetter(HiddenAbilityCondition::hiddenAbility)).apply((Applicative)inst, HiddenAbilityCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return ModLootConditions.HIDDEN_ABILITY;
    }

    public boolean test(LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        return ReleaseUtils.hasHiddenAbility(pokemon, this.hiddenAbility);
    }
}

