/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.loot.conditions;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.pokemon.evolution.PreEvolution;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.conditions.ModLootConditions;
import com.emperdog.releaserewards.services.Services;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record EvolutionStageCondition(List<Integer> stages, boolean invert) implements LootItemCondition
{
    public static final MapCodec<EvolutionStageCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.listOf().fieldOf("stages").forGetter(EvolutionStageCondition::stages), (App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(EvolutionStageCondition::invert)).apply((Applicative)inst, EvolutionStageCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return ModLootConditions.EVOLUTION_STAGE;
    }

    public boolean test(LootContext context) {
        Pokemon pokemon = (Pokemon)context.getParam(ModLootContextParams.POKEMON);
        int estimatedEvoStage = 1;
        boolean hasPreOrEvo = false;
        int iterations = 0;
        if (!Objects.isNull(pokemon.getForm().getPreEvolution())) {
            PreEvolution currentPreEvo = pokemon.getForm().getPreEvolution();
            while (!Objects.isNull(currentPreEvo)) {
                if (iterations == Services.CONFIG.getMaxPreEvoSearchDepth()) {
                    estimatedEvoStage = 0;
                    break;
                }
                ++estimatedEvoStage;
                if (Objects.isNull(currentPreEvo.getForm().getPreEvolution())) break;
                currentPreEvo = currentPreEvo.getForm().getPreEvolution();
                ++iterations;
            }
            hasPreOrEvo = true;
        }
        HashSet evos = pokemon.getForm().getEvolutions();
        iterations = 0;
        while (!evos.isEmpty()) {
            if (iterations == Services.CONFIG.getMaxEvoSearchDepth()) {
                estimatedEvoStage = 0;
                break;
            }
            HashSet nextEvos = new HashSet();
            for (Evolution evo : evos) {
                Set evoEvos;
                String evoSpeciesName = evo.getResult().getSpecies();
                assert (evoSpeciesName != null);
                ResourceLocation evoSpecies = ResourceLocation.tryParse((String)evoSpeciesName);
                if (Objects.isNull(PokemonSpecies.getByIdentifier((ResourceLocation)evoSpecies))) {
                    evoSpecies = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)evoSpeciesName);
                }
                if ((evoEvos = PokemonSpecies.getByIdentifier((ResourceLocation)evoSpecies).getForm(evo.getResult().getAspects()).getEvolutions()).isEmpty()) continue;
                nextEvos.addAll(evoEvos);
            }
            evos = nextEvos;
            hasPreOrEvo = true;
            ++iterations;
        }
        if (!hasPreOrEvo) {
            --estimatedEvoStage;
        }
        return this.stages.contains(estimatedEvoStage) != this.invert;
    }
}

