/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards.data;

import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.MoveTarget;
import com.emperdog.releaserewards.loot.ReleaseUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class MovePredicate {
    private final double power;
    private final double accuracy;
    private final ElementalType type;
    private final String category;
    private final int priority;
    private final String target;
    private final int maxpp;
    public static final MapCodec<MovePredicate> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.optionalFieldOf("power", (Object)-1).forGetter(e -> (int)e.power), (App)Codec.INT.optionalFieldOf("accuracy", (Object)0).forGetter(e -> (int)e.accuracy), (App)ElementalType.getBY_STRING_CODEC().optionalFieldOf("type", (Object)ReleaseUtils.EMPTY_TYPE).forGetter(e -> e.type), (App)Codec.STRING.optionalFieldOf("category", (Object)"any").forGetter(e -> e.category), (App)Codec.INT.optionalFieldOf("priority", (Object)-99).forGetter(e -> e.priority), (App)Codec.STRING.optionalFieldOf("target", (Object)"").forGetter(e -> e.target), (App)Codec.INT.optionalFieldOf("max_pp", (Object)0).forGetter(e -> e.maxpp)).apply((Applicative)inst, MovePredicate::new));

    public MovePredicate(double power, double accuracy, ElementalType type, String category, int priority, String target, int maxpp) {
        this.power = power;
        this.accuracy = accuracy;
        this.type = type;
        this.category = category;
        this.priority = priority;
        this.target = target;
        this.maxpp = maxpp;
    }

    public DamageCategory getDamageCategory() {
        return ReleaseUtils.getDamageCategoryFromAlias(this.category);
    }

    public double getPower() {
        return this.power;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public ElementalType getType() {
        return this.type;
    }

    public MoveTarget getTarget() {
        return this.target.isEmpty() ? null : ReleaseUtils.getMoveTargetFromAlias(this.target);
    }

    public int getPriority() {
        return this.priority;
    }

    public int getMaxpp() {
        return this.maxpp;
    }
}

