/*
 * Decompiled with CFR 0.152.
 */
package com.emperdog.releaserewards;

import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.emperdog.releaserewards.ReleaseRewards;
import com.emperdog.releaserewards.loot.ModLootContextParams;
import com.emperdog.releaserewards.loot.ReleaseUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class ReleaseHandler {
    public static final ResourceKey<LootTable> GLOBAL_REWARD_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ReleaseRewards.resource("rewards/global"));
    public static final Map<ElementalType, ResourceKey<LootTable>> TYPE_REWARD_TABLES = ElementalTypes.INSTANCE.all().stream().collect(Collectors.toMap(type -> type, type -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ReleaseRewards.resource("rewards/types/" + type.getShowdownId()))));
    public static HashMap<ResourceLocation, ResourceKey<LootTable>> STORED_SPECIES_REWARD_TABLES = new HashMap();

    public static Unit handleReleaseEvent(ReleasePokemonEvent event) {
        ServerPlayer player = event.getPlayer();
        Pokemon pokemon = event.getPokemon();
        Level level = player.level();
        ReloadableServerRegistries.Holder reloadableRegistries = Objects.requireNonNull(player.getServer()).reloadableRegistries();
        LootTable globalTable = reloadableRegistries.getLootTable(GLOBAL_REWARD_TABLE);
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)level);
        builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player);
        builder.withParameter(ModLootContextParams.POKEMON, (Object)pokemon);
        LootParams params = builder.create(ModLootContextParams.Sets.PLAYER_AND_POKEMON);
        ReleaseHandler.giveLootToPlayer(player, (List<ItemStack>)globalTable.getRandomItems(params));
        return Unit.INSTANCE;
    }

    public static ResourceKey<LootTable> getGlobalRewards() {
        return GLOBAL_REWARD_TABLE;
    }

    public static ResourceKey<LootTable> getTypeRewardTable(ElementalType type) {
        return TYPE_REWARD_TABLES.get(type);
    }

    public static ResourceKey<LootTable> getSpeciesRewardTable(Pokemon pokemon) {
        return ReleaseHandler.getSpeciesRewardTable(pokemon.getSpecies().resourceIdentifier);
    }

    public static ResourceKey<LootTable> getSpeciesRewardTable(ResourceLocation speciesLocation) {
        if (STORED_SPECIES_REWARD_TABLES.containsKey(speciesLocation)) {
            return STORED_SPECIES_REWARD_TABLES.get(speciesLocation);
        }
        ResourceLocation speciesTableLocation = ReleaseUtils.getSpeciesTableLocation(speciesLocation);
        ResourceKey speciesTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)speciesTableLocation);
        STORED_SPECIES_REWARD_TABLES.put(speciesLocation, (ResourceKey<LootTable>)speciesTableKey);
        return speciesTableKey;
    }

    public static void giveLootToPlayer(ServerPlayer player, List<ItemStack> loot) {
        loot.forEach(stack -> {
            boolean bl = player.getInventory().add(stack);
            if (bl && stack.isEmpty()) {
                stack.setCount(1);
                ItemEntity entity = player.drop(stack, false);
                if (entity != null) {
                    entity.makeFakeItem();
                }
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.inventoryMenu.broadcastChanges();
            } else {
                ItemEntity entity = player.drop(stack, false);
                if (entity != null) {
                    entity.setNoPickUpDelay();
                    entity.setTarget(player.getUUID());
                }
            }
        });
    }
}

