/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.inventory.CraftResultSlot;
import com.jaquadro.minecraft.storagedrawers.inventory.RestrictedSlot;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ContainerFramingTable
extends AbstractContainerMenu {
    private static final int InventoryX = 8;
    private static final int InventoryY = 84;
    private static final int HotbarY = 142;
    private static final int InputX = 23;
    private static final int InputY = 35;
    private static final int MaterialSideX = 50;
    private static final int MaterialSideY = 17;
    private static final int MaterialTrimX = 102;
    private static final int MaterialTrimY = 17;
    private static final int MaterialFrontX = 50;
    private static final int MaterialFrontY = 53;
    private static final int OutputX = 133;
    private static final int OutputY = 35;
    private final BlockEntityFramingTable blockEntity;
    private final Container tableInventory;
    private final Container craftResult;
    private final ContainerLevelAccess access;
    private final Player player;
    private Slot inputSlot;
    private Slot materialSideSlot;
    private Slot materialTrimSlot;
    private Slot materialFrontSlot;
    private Slot outputSlot;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public ContainerFramingTable(int windowId, Inventory playerInv, Optional<PositionContent> content) {
        this((MenuType)ModContainers.FRAMING_TABLE.get(), windowId, playerInv, PositionContent.getOrNull(content, playerInv.player.level(), BlockEntityFramingTable.class));
    }

    public ContainerFramingTable(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, BlockEntityFramingTable blockEntity) {
        super(type, windowId);
        int i;
        this.blockEntity = blockEntity;
        this.tableInventory = blockEntity.inventory();
        this.craftResult = blockEntity.inventory();
        this.access = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        this.player = playerInventory.player;
        this.inputSlot = this.addSlot(new RestrictedSlot(this.tableInventory, 0, 23, 35));
        this.materialSideSlot = this.addSlot(new RestrictedSlot(this.tableInventory, 1, 50, 17));
        this.materialTrimSlot = this.addSlot(new RestrictedSlot(this.tableInventory, 2, 102, 17));
        this.materialFrontSlot = this.addSlot(new RestrictedSlot(this.tableInventory, 3, 50, 53));
        this.outputSlot = this.addSlot(new CraftResultSlot(playerInventory.player, this.tableInventory, this.craftResult, new int[]{0, 1, 2, 3}, 4, 133, 35));
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142)));
        }
        this.slotsChanged(this.tableInventory);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        int inventoryStart = this.playerSlots.get((int)0).index;
        int hotbarStart = this.hotbarSlots.get((int)0).index;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).index + 1;
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (slotIndex == 4) {
                if (!this.moveItemStackTo(slotStack, inventoryStart, hotbarEnd, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (slotIndex == 0 || BlockEntityFramingTable.isMaterialSlot(slotIndex) ? !this.moveItemStackTo(slotStack, inventoryStart, hotbarEnd, true) : slotIndex >= inventoryStart && slotIndex < hotbarEnd && (this.blockEntity.isItemValidTarget(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, false) : (BlockEntityFramingTable.isItemValidMaterial(slotStack) ? !this.moveItemStackTo(slotStack, 1, 4, false) : (slotIndex < hotbarStart ? !this.moveItemStackTo(slotStack, hotbarStart, hotbarEnd, false) : !this.moveItemStackTo(slotStack, inventoryStart, hotbarStart, false))))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return this.tableInventory.stillValid(player);
    }
}

