/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import com.jaquadro.minecraft.storagedrawers.integration.DrawerOverlay;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TheOneProbe
implements Function<ITheOneProbe, Void> {
    private static final TheOneProbe INSTANCE = new TheOneProbe();

    public static TheOneProbe getInstance() {
        return INSTANCE;
    }

    @Override
    public Void apply(ITheOneProbe probe) {
        if (ModClientConfig.INSTANCE.isLoaded() && !((Boolean)ModClientConfig.INSTANCE.INTEGRATION.enableTheOneProbe.get()).booleanValue()) {
            return null;
        }
        probe.registerProvider((IProbeInfoProvider)new DrawerProbeProvider());
        return null;
    }

    private static class DrawerProbeProvider
    implements IProbeInfoProvider {
        private DrawerProbeProvider() {
        }

        public ResourceLocation getID() {
            return StorageDrawers.rl("drawerprobe");
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo probe, Player player, Level world, BlockState blockState, IProbeHitData data) {
            BlockEntityDrawers blockEntityDrawers = WorldUtils.getBlockEntity((BlockGetter)world, data.getPos(), BlockEntityDrawers.class);
            if (blockEntityDrawers != null) {
                DrawerOverlay overlay = new DrawerOverlay();
                for (Component component : overlay.getOverlay(blockEntityDrawers, true)) {
                    probe.text(component);
                }
            }
        }
    }
}

