/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import mcjty.incontrol.commands.Counter;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.entity.EntityTypeTest;

public class CmdList
implements Command<CommandSourceStack> {
    private static final CmdList CMD = new CmdList();
    public static final EntityTypeTest<Entity, ?> ANY_TYPE = new EntityTypeTest<Entity, Entity>(){

        public Entity tryCast(Entity entity) {
            return entity;
        }

        public Class<? extends Entity> getBaseClass() {
            return Entity.class;
        }
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"list").requires(cs -> cs.hasPermission(2))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (player != null) {
            ResourceKey dimension = player.getCommandSenderWorld().dimension();
            ServerLevel worldServer = player.getCommandSenderWorld().getServer().getLevel(dimension);
            Counter counter = new Counter();
            worldServer.getEntities(ANY_TYPE, e -> e instanceof Mob).forEach(input -> counter.add(BuiltInRegistries.ENTITY_TYPE.getKey((Object)input.getType())));
            for (Map.Entry entry : counter.getMap().entrySet()) {
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Mob " + ((ResourceLocation)entry.getKey()).toString() + ": " + String.valueOf(entry.getValue()))));
            }
        }
        return 0;
    }
}

