// This software contains source code provided by NVIDIA Corporation.
// This is a derivative of NVIDIA FXAA 3.11 by TIMOTHY LOTTES

// This code is from https://gist.github.com/cart/7d2da58eb28c75c0952787f29f3e562f
// I could not find a link to the license of the original code, since the GitHub repo was taken down.

const float lumaScale = 6.0;

vec4 FxaaTexOff(sampler2D t, vec2 p, vec2 o, vec2 r) {
    return textureLod(t, p + (o * r), 0.0);
}
float FxaaLuma(vec4 rgba) {
    return lumaScale * dot(rgba.rgb, vec3(0.299, 0.587, 0.114));
}
float FxaaSat(float x) {
    return clamp(x, 0.0, 1.0);
}

vec4 FxaaPixelShader(
    vec2 pos,
    //
    // Input color texture.
    // {rgb_} = color in linear or perceptual color space
    // if (FXAA_GREEN_AS_LUMA == 0)
    //     {__a} = luma in perceptual color space (not linear)
    sampler2D tex,
    //
    // Only used on FXAA Quality.
    // This must be from a constant/uniform.
    // {x_} = 1.0/screenWidthInPixels
    // {_y} = 1.0/screenHeightInPixels
    vec2 fxaaQualityRcpFrame,
    //
    // Only used on FXAA Quality.
    // This used to be the FXAA_QUALITY_SUBPIX define.
    // It is here now to allow easier tuning.
    // Choose the amount of sub-pixel aliasing removal.
    // This can effect sharpness.
    //   1.00 - upper limit (softer)
    //   0.75 - default amount of filtering
    //   0.50 - lower limit (sharper, less sub-pixel aliasing removal)
    //   0.25 - almost off
    //   0.00 - completely off
    float fxaaQualitySubpix,
    //
    // Only used on FXAA Quality.
    // This used to be the FXAA_QUALITY_EDGE_THRESHOLD define.
    // It is here now to allow easier tuning.
    // The minimum amount of local contrast required to apply algorithm.
    //   0.333 - too little (faster)
    //   0.250 - low quality
    //   0.166 - default
    //   0.125 - high quality
    //   0.063 - overkill (slower)
    float fxaaQualityEdgeThreshold,
    //
    // Only used on FXAA Quality.
    // This used to be the FXAA_QUALITY_EDGE_THRESHOLD_MIN define.
    // It is here now to allow easier tuning.
    // Trims the algorithm from processing darks.
    //   0.0833 - upper limit (default, the start of visible unfiltered edges)
    //   0.0625 - high quality (faster)
    //   0.0312 - visible limit (slower)
    // Special notes when using FXAA_GREEN_AS_LUMA,
    //   Likely want to set this to zero.
    //   As colors that are mostly not-green
    //   will appear very dark in the green channel!
    //   Tune by looking at mostly non-green content,
    //   then start at zero and increase until aliasing is a problem.
    float fxaaQualityEdgeThresholdMin
) {

    // high 39
    float FXAA_QUALITY_P0 = 1.0;
    float FXAA_QUALITY_P1 = 1.0;
    float FXAA_QUALITY_P2 = 1.0;
    float FXAA_QUALITY_P3 = 1.0;
    float FXAA_QUALITY_P4 = 1.0;
    float FXAA_QUALITY_P5 = 1.5;
    float FXAA_QUALITY_P6 = 2.0;
    float FXAA_QUALITY_P7 = 2.0;
    float FXAA_QUALITY_P8 = 2.0;
    float FXAA_QUALITY_P9 = 2.0;
    float FXAA_QUALITY_P10 = 4.0;
    float FXAA_QUALITY_P11 = 8.0;

    // med 13
    // float FXAA_QUALITY_P0 = 1.0;
    // float FXAA_QUALITY_P1 = 1.5;
    // float FXAA_QUALITY_P2 = 2.0;
    // float FXAA_QUALITY_P3 = 2.0;
    // float FXAA_QUALITY_P4 = 4.0;
    // float FXAA_QUALITY_P5 = 12.0;
    vec2 posM;
    posM.x = pos.x;
    posM.y = pos.y;

    vec4 rgbyM = textureLod(tex, posM, 0.0);
    float lumaM = FxaaLuma(rgbyM);
    float lumaS = FxaaLuma(FxaaTexOff(tex, posM, vec2(0.0, 1.0), fxaaQualityRcpFrame.xy));
    float lumaE = FxaaLuma(FxaaTexOff(tex, posM, vec2(1.0, 0.0), fxaaQualityRcpFrame.xy));
    float lumaN = FxaaLuma(FxaaTexOff(tex, posM, vec2(0.0, -1.0), fxaaQualityRcpFrame.xy));
    float lumaW = FxaaLuma(FxaaTexOff(tex, posM, vec2(-1.0, 0.0), fxaaQualityRcpFrame.xy));

    float maxSM = max(lumaS, lumaM);
    float minSM = min(lumaS, lumaM);
    float maxESM = max(lumaE, maxSM);
    float minESM = min(lumaE, minSM);
    float maxWN = max(lumaN, lumaW);
    float minWN = min(lumaN, lumaW);
    float rangeMax = max(maxWN, maxESM);
    float rangeMin = min(minWN, minESM);
    float rangeMaxScaled = rangeMax * fxaaQualityEdgeThreshold;
    float range = rangeMax - rangeMin;
    float rangeMaxClamped = max(fxaaQualityEdgeThresholdMin, rangeMaxScaled);
    bool earlyExit = range < rangeMaxClamped;

    if (earlyExit)
        return rgbyM;

    float lumaNW = FxaaLuma(FxaaTexOff(tex, posM, vec2(-1.0, -1.0), fxaaQualityRcpFrame.xy));
    float lumaSE = FxaaLuma(FxaaTexOff(tex, posM, vec2(1.0, 1.0), fxaaQualityRcpFrame.xy));
    float lumaNE = FxaaLuma(FxaaTexOff(tex, posM, vec2(1.0, -1.0), fxaaQualityRcpFrame.xy));
    float lumaSW = FxaaLuma(FxaaTexOff(tex, posM, vec2(-1.0, 1.0), fxaaQualityRcpFrame.xy));

    float lumaNS = lumaN + lumaS;
    float lumaWE = lumaW + lumaE;
    float subpixRcpRange = 1.0 / range;
    float subpixNSWE = lumaNS + lumaWE;
    float edgeHorz1 = (-2.0 * lumaM) + lumaNS;
    float edgeVert1 = (-2.0 * lumaM) + lumaWE;

    float lumaNESE = lumaNE + lumaSE;
    float lumaNWNE = lumaNW + lumaNE;
    float edgeHorz2 = (-2.0 * lumaE) + lumaNESE;
    float edgeVert2 = (-2.0 * lumaN) + lumaNWNE;

    float lumaNWSW = lumaNW + lumaSW;
    float lumaSWSE = lumaSW + lumaSE;
    float edgeHorz4 = (abs(edgeHorz1) * 2.0) + abs(edgeHorz2);
    float edgeVert4 = (abs(edgeVert1) * 2.0) + abs(edgeVert2);
    float edgeHorz3 = (-2.0 * lumaW) + lumaNWSW;
    float edgeVert3 = (-2.0 * lumaS) + lumaSWSE;
    float edgeHorz = abs(edgeHorz3) + edgeHorz4;
    float edgeVert = abs(edgeVert3) + edgeVert4;

    float subpixNWSWNESE = lumaNWSW + lumaNESE;
    float lengthSign = fxaaQualityRcpFrame.x;
    bool horzSpan = edgeHorz >= edgeVert;
    float subpixA = subpixNSWE * 2.0 + subpixNWSWNESE;

    if (!horzSpan) lumaN = lumaW;
    if (!horzSpan) lumaS = lumaE;
    if (horzSpan) lengthSign = fxaaQualityRcpFrame.y;
    float subpixB = (subpixA * (1.0 / 12.0)) - lumaM;

    float gradientN = lumaN - lumaM;
    float gradientS = lumaS - lumaM;
    float lumaNN = lumaN + lumaM;
    float lumaSS = lumaS + lumaM;
    bool pairN = abs(gradientN) >= abs(gradientS);
    float gradient = max(abs(gradientN), abs(gradientS));
    if (pairN) lengthSign = -lengthSign;
    float subpixC = FxaaSat(abs(subpixB) * subpixRcpRange);

    vec2 posB;
    posB.x = posM.x;
    posB.y = posM.y;
    vec2 offNP;
    offNP.x = (!horzSpan) ? 0.0 : fxaaQualityRcpFrame.x;
    offNP.y = (horzSpan) ? 0.0 : fxaaQualityRcpFrame.y;
    if (!horzSpan) posB.x += lengthSign * 0.5;
    if (horzSpan) posB.y += lengthSign * 0.5;

    vec2 posN;
    posN.x = posB.x - offNP.x * FXAA_QUALITY_P0;
    posN.y = posB.y - offNP.y * FXAA_QUALITY_P0;
    vec2 posP;
    posP.x = posB.x + offNP.x * FXAA_QUALITY_P0;
    posP.y = posB.y + offNP.y * FXAA_QUALITY_P0;
    float subpixD = ((-2.0) * subpixC) + 3.0;
    float lumaEndN = FxaaLuma(textureLod(tex, posN, 0.0));
    float subpixE = subpixC * subpixC;
    float lumaEndP = FxaaLuma(textureLod(tex, posP, 0.0));

    if (!pairN) lumaNN = lumaSS;
    float gradientScaled = gradient * 1.0 / 4.0;
    float lumaMM = lumaM - lumaNN * 0.5;
    float subpixF = subpixD * subpixE;
    bool lumaMLTZero = lumaMM < 0.0;

    lumaEndN -= lumaNN * 0.5;
    lumaEndP -= lumaNN * 0.5;
    bool doneN = abs(lumaEndN) >= gradientScaled;
    bool doneP = abs(lumaEndP) >= gradientScaled;
    if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P1;
    if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P1;
    bool doneNP = (!doneN) || (!doneP);
    if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P1;
    if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P1;

    if (doneNP) {
        if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
        if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
        if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
        if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
        doneN = abs(lumaEndN) >= gradientScaled;
        doneP = abs(lumaEndP) >= gradientScaled;
        if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P2;
        if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P2;
        doneNP = (!doneN) || (!doneP);
        if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P2;
        if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P2;

        // PS 3
        if (doneNP) {
            if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
            if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
            if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
            if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
            doneN = abs(lumaEndN) >= gradientScaled;
            doneP = abs(lumaEndP) >= gradientScaled;
            if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P3;
            if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P3;
            doneNP = (!doneN) || (!doneP);
            if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P3;
            if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P3;

            // PS 4
            if (doneNP) {
                if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
                if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
                if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                doneN = abs(lumaEndN) >= gradientScaled;
                doneP = abs(lumaEndP) >= gradientScaled;
                if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P4;
                if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P4;
                doneNP = (!doneN) || (!doneP);
                if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P4;
                if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P4;

                // PS 5
                if (doneNP) {
                    if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
                    if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
                    if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                    if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                    doneN = abs(lumaEndN) >= gradientScaled;
                    doneP = abs(lumaEndP) >= gradientScaled;
                    if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P5;
                    if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P5;
                    doneNP = (!doneN) || (!doneP);
                    if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P5;
                    if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P5;

                    // PS 6
                    if (doneNP) {
                        if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
                        if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
                        if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                        if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                        doneN = abs(lumaEndN) >= gradientScaled;
                        doneP = abs(lumaEndP) >= gradientScaled;
                        if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P6;
                        if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P6;
                        doneNP = (!doneN) || (!doneP);
                        if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P6;
                        if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P6;

                        // PS 7
                        if (doneNP) {
                            if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
                            if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
                            if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                            if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                            doneN = abs(lumaEndN) >= gradientScaled;
                            doneP = abs(lumaEndP) >= gradientScaled;
                            if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P7;
                            if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P7;
                            doneNP = (!doneN) || (!doneP);
                            if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P7;
                            if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P7;

                            // PS 8
                            if (doneNP) {
                                if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
                                if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
                                if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                                if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                                doneN = abs(lumaEndN) >= gradientScaled;
                                doneP = abs(lumaEndP) >= gradientScaled;
                                if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P8;
                                if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P8;
                                doneNP = (!doneN) || (!doneP);
                                if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P8;
                                if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P8;

                                // PS 9
                                if (doneNP) {
                                    if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
                                    if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
                                    if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                                    if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                                    doneN = abs(lumaEndN) >= gradientScaled;
                                    doneP = abs(lumaEndP) >= gradientScaled;
                                    if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P9;
                                    if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P9;
                                    doneNP = (!doneN) || (!doneP);
                                    if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P9;
                                    if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P9;

                                    // PS 10
                                    if (doneNP) {
                                        if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
                                        if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
                                        if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                                        if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                                        doneN = abs(lumaEndN) >= gradientScaled;
                                        doneP = abs(lumaEndP) >= gradientScaled;
                                        if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P10;
                                        if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P10;
                                        doneNP = (!doneN) || (!doneP);
                                        if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P10;
                                        if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P10;

                                        // PS 11
                                        if (doneNP) {
                                            if (!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
                                            if (!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
                                            if (!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                                            if (!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                                            doneN = abs(lumaEndN) >= gradientScaled;
                                            doneP = abs(lumaEndP) >= gradientScaled;
                                            if (!doneN) posN.x -= offNP.x * FXAA_QUALITY_P11;
                                            if (!doneN) posN.y -= offNP.y * FXAA_QUALITY_P11;
                                            doneNP = (!doneN) || (!doneP);
                                            if (!doneP) posP.x += offNP.x * FXAA_QUALITY_P11;
                                            if (!doneP) posP.y += offNP.y * FXAA_QUALITY_P11;

                                            // PS 12
                                            // if(doneNP) {
                                            //     if(!doneN) lumaEndN = FxaaLuma(textureLod(tex, posN.xy, 0.0));
                                            //     if(!doneP) lumaEndP = FxaaLuma(textureLod(tex, posP.xy, 0.0));
                                            //     if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                                            //     if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                                            //     doneN = abs(lumaEndN) >= gradientScaled;
                                            //     doneP = abs(lumaEndP) >= gradientScaled;
                                            //     if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P12;
                                            //     if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P12;
                                            //     doneNP = (!doneN) || (!doneP);
                                            //     if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P12;
                                            //     if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P12;
                                            // }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    float dstN = posM.x - posN.x;
    float dstP = posP.x - posM.x;
    if (!horzSpan) dstN = posM.y - posN.y;
    if (!horzSpan) dstP = posP.y - posM.y;

    bool goodSpanN = (lumaEndN < 0.0) != lumaMLTZero;
    float spanLength = (dstP + dstN);
    bool goodSpanP = (lumaEndP < 0.0) != lumaMLTZero;
    float spanLengthRcp = 1.0 / spanLength;

    bool directionN = dstN < dstP;
    float dst = min(dstN, dstP);
    bool goodSpan = directionN ? goodSpanN : goodSpanP;
    float subpixG = subpixF * subpixF;
    float pixelOffset = (dst * (-spanLengthRcp)) + 0.5;
    float subpixH = subpixG * fxaaQualitySubpix;

    float pixelOffsetGood = goodSpan ? pixelOffset : 0.0;
    float pixelOffsetSubpix = max(pixelOffsetGood, subpixH);
    if (!horzSpan) posM.x += pixelOffsetSubpix * lengthSign;
    if (horzSpan) posM.y += pixelOffsetSubpix * lengthSign;
    return vec4(textureLod(tex, posM, 0.0).xyz, lumaM);
}
