#version 150

uniform sampler2D Sampler0;
uniform vec4 ColorModulator;
in vec2 texCoord0;
in vec4 vertexColor;
out vec4 fragColor;

uniform float GameTime;

void main() {
    float speed = 0.03;
    vec2 uv = texCoord0;
    uv.y += GameTime * speed;
    uv.x += sin(GameTime * 0.5) * 0.05;

    vec4 color = texture(Sampler0, uv);

    float pulse = 0.5 + 0.5 * sin(GameTime * 3.0);
    color.rgb *= mix(0.6, 1.4, pulse);

    fragColor = color * vertexColor * ColorModulator;
}