/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.blocks;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import net.createcobblestone.blocks.MechanicalGeneratorBlockEntity;
import net.createcobblestone.data.GeneratorType;
import net.createcobblestone.index.BlockEntities;
import net.createcobblestone.index.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class MechanicalGeneratorBlock
extends HorizontalKineticBlock
implements IBE<MechanicalGeneratorBlockEntity> {
    public MechanicalGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferredSide = this.getPreferredHorizontalFacing(context);
        if (preferredSide != null) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)preferredSide);
        }
        return super.m_5573_(context);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public Class<MechanicalGeneratorBlockEntity> getBlockEntityClass() {
        return MechanicalGeneratorBlockEntity.class;
    }

    public BlockEntityType<? extends MechanicalGeneratorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockEntities.MECHANICAL_GENERATOR.get();
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.SLOW;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        try {
            GeneratorType type = GeneratorType.fromItem(player.m_21205_().m_41720_());
            if (type.getBlock() == null || type == GeneratorType.NONE || !Config.common().isEnabled(type)) {
                return InteractionResult.FAIL;
            }
            MechanicalGeneratorBlockEntity be = (MechanicalGeneratorBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
            if (be != null) {
                be.updateType(type);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        catch (NullPointerException ignored) {
            return InteractionResult.FAIL;
        }
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        MechanicalGeneratorBlockEntity blockEntity = (MechanicalGeneratorBlockEntity)level.m_7702_(pos);
        if (blockEntity == null) {
            return stack;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", blockEntity.type.getId());
        stack.m_41700_("BlockEntityTag", (Tag)tag);
        return stack;
    }
}

