/*
 * Decompiled with CFR 0.152.
 */
package elocindev.welcomescreen.fancymenu;

import elocindev.welcomescreen.util.PathUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class CustomGUIResolver {
    public static void load() {
        CustomGUIResolver.resolveCustomGuis();
    }

    public static boolean resolveCustomGuis() {
        Path customguifile = PathUtils.getConfigPath().resolve("fancymenu/custom_gui_screens.txt");
        try {
            if (!Files.exists(customguifile, new LinkOption[0])) {
                CustomGUIResolver.createDefaultFile(customguifile);
                return true;
            }
            List<String> lines = Files.readAllLines(customguifile);
            boolean hasUpdate = lines.stream().anyMatch(line -> line.contains("welcomescreen_update"));
            boolean hasWelcome = lines.stream().anyMatch(line -> line.contains("welcomescreen_welcome"));
            if (!hasUpdate || !hasWelcome) {
                if (!hasUpdate) {
                    lines.add(CustomGUIResolver.getDefaultUpdateGui());
                }
                if (!hasWelcome) {
                    lines.add(CustomGUIResolver.getDefaultWelcomeGui());
                }
                Files.write(customguifile, lines, new OpenOption[0]);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void createDefaultFile(Path customguifile) throws IOException {
        List<String> defaultContent = List.of("type = custom_gui_screens", "", "overridden_screens {", "}", "", CustomGUIResolver.getDefaultUpdateGui(), CustomGUIResolver.getDefaultWelcomeGui());
        Files.write(customguifile, defaultContent, new OpenOption[0]);
    }

    private static String getDefaultUpdateGui() {
        return "custom_gui {\n  identifier = welcomescreen_update\n  title = What's New?\n  allow_esc = true\n  transparent_world_background = true\n  transparent_world_background_overlay = false\n  pause_game = true\n}";
    }

    private static String getDefaultWelcomeGui() {
        return "custom_gui {\n  identifier = welcomescreen_welcome\n  title = \n  allow_esc = true\n  transparent_world_background = true\n  transparent_world_background_overlay = false\n  pause_game = true\n}";
    }
}

