/*
 * Decompiled with CFR 0.152.
 */
package sk.alloy_smelter.screen;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import sk.alloy_smelter.event.ForgeOutputTakenEvent;

public abstract class IESlot
extends Slot {
    final AbstractContainerMenu containerMenu;

    public IESlot(AbstractContainerMenu containerMenu, Container inv, int id, int x, int y) {
        super(inv, id, x, y);
        this.containerMenu = containerMenu;
    }

    public boolean m_5857_(ItemStack itemStack) {
        return true;
    }

    private static class SlotItemHandlerIE
    extends SlotItemHandler {
        public SlotItemHandlerIE(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int m_5866_(@NotNull ItemStack stack) {
            return Math.min(Math.min(this.m_6641_(), stack.m_41741_()), super.m_5866_(stack));
        }
    }

    public static class IEFuelSlot
    extends SlotItemHandlerIE {
        public IEFuelSlot(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return AbstractFurnaceBlockEntity.m_58399_((ItemStack)stack) || IEFuelSlot.isBucket(stack);
        }

        @Override
        public int m_5866_(@NotNull ItemStack stack) {
            return IEFuelSlot.isBucket(stack) ? 1 : super.m_5866_(stack);
        }

        public static boolean isBucket(ItemStack stack) {
            return stack.m_41720_() == Items.f_42446_;
        }
    }

    public static class IEOutputSlot
    extends SlotItemHandlerIE {
        private final Player player;
        private final Level level;

        public IEOutputSlot(IItemHandler inv, int id, int x, int y, Player player, Level level) {
            super(inv, id, x, y);
            this.level = level;
            this.player = player;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            if (!stack.m_41619_() && !this.level.m_5776_()) {
                this.triggerTakeEvent(stack, stack.m_41613_());
            }
        }

        private void triggerTakeEvent(ItemStack stack, int amount) {
            ItemStack outputStack = stack.m_41777_();
            outputStack.m_41764_(amount);
            ForgeOutputTakenEvent event = new ForgeOutputTakenEvent(this.player, outputStack);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }
}

