/*
 * Decompiled with CFR 0.152.
 */
package sk.alloy_smelter.screen;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import sk.alloy_smelter.block.ForgeControllerBlockEntity;
import sk.alloy_smelter.event.ForgeOutputTakenEvent;
import sk.alloy_smelter.recipe.SmeltingRecipe;
import sk.alloy_smelter.registry.MenuTypes;
import sk.alloy_smelter.registry.Tags;
import sk.alloy_smelter.screen.IESlot;

public class ForgeControllerMenu
extends AbstractContainerMenu {
    public final ForgeControllerBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public ForgeControllerMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(7));
    }

    public ForgeControllerMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)MenuTypes.FORGE_CONTROLLER_MENU.get(), pContainerId);
        ForgeControllerMenu.m_38869_((Container)inv, (int)7);
        this.blockEntity = (ForgeControllerBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new IESlot.IEFuelSlot((IItemHandler)iItemHandler, 0, 20, 45));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 1, 20, 25));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 2, 41, 25));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 3, 62, 25));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 4, 83, 25));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 5, 104, 25));
            this.m_38897_((Slot)new IESlot.IEOutputSlot((IItemHandler)iItemHandler, 6, 135, 25, inv.f_35978_, this.level));
        });
        this.m_38884_(data);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int lastSlotIndex = 6;
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        int slotCount = lastSlotIndex + 1;
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 36 + slotCount, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 36 + slotCount) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        if (index - 36 == lastSlotIndex && !copyOfSourceStack.m_41619_() && !this.level.m_5776_()) {
            this.triggerTakeEvent(playerIn, copyOfSourceStack, copyOfSourceStack.m_41613_());
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void triggerTakeEvent(Player player, ItemStack stack, int amount) {
        ItemStack outputStack = stack.m_41777_();
        outputStack.m_41764_(amount);
        ForgeOutputTakenEvent event = new ForgeOutputTakenEvent(player, outputStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    protected static boolean valid(ContainerLevelAccess access, Player player, TagKey<Block> targetBlock) {
        return (Boolean)access.m_39299_((levelPosConsumer, defaultValue) -> !levelPosConsumer.m_8055_(defaultValue).m_204336_(targetBlock) ? false : player.m_20275_((double)defaultValue.m_123341_() + 0.5, (double)defaultValue.m_123342_() + 0.5, (double)defaultValue.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public boolean m_6875_(Player player) {
        return ForgeControllerMenu.valid(ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), player, Tags.FORGE_CONTROLLER);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public boolean isBurning() {
        return this.data.m_6413_(1) > 0;
    }

    public int getArrowProgress() {
        Optional<SmeltingRecipe> recipe = this.blockEntity.getMatchingRecipe();
        int smeltingTime = this.data.m_6413_(0);
        int maxSmeltingTime = 0;
        if (recipe.isPresent()) {
            maxSmeltingTime = recipe.get().getSmeltingTime();
        }
        int progressSize = 26;
        return maxSmeltingTime != 0 && smeltingTime != 0 ? smeltingTime * progressSize / maxSmeltingTime : 0;
    }

    public int getBurnProgress() {
        int fuelTime = this.data.m_6413_(1);
        int maxFuelTime = this.data.m_6413_(2);
        int progressSize = 12;
        return maxFuelTime != 0 && fuelTime != 0 ? fuelTime * progressSize / maxFuelTime : 0;
    }
}

