/*
 * Decompiled with CFR 0.152.
 */
package sk.alloy_smelter.registry;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import sk.alloy_smelter.block.ForgeControllerBlock;
import sk.alloy_smelter.registry.Items;

public class Blocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"alloy_smelter");
    public static final RegistryObject<Block> FORGE_CONTROLLER_TIER1 = Blocks.registerBlock("forge_controller_tier1", () -> new ForgeControllerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)net.minecraft.world.level.block.Blocks.f_50076_).m_60978_(4.0f).m_60953_(Blocks.litBlockEmission(12)), 1));
    public static final RegistryObject<Block> FORGE_CONTROLLER_TIER2 = Blocks.registerBlock("forge_controller_tier2", () -> new ForgeControllerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)net.minecraft.world.level.block.Blocks.f_50076_).m_60978_(5.0f).m_60953_(Blocks.litBlockEmission(12)), 2));
    public static final RegistryObject<Block> FORGE_CONTROLLER_TIER3 = Blocks.registerBlock("forge_controller_tier3", () -> new ForgeControllerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)net.minecraft.world.level.block.Blocks.f_50076_).m_60978_(6.0f).m_60953_(Blocks.litBlockEmission(12)), 3));

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return blockState -> (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        Blocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return Items.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

