/*
 * Decompiled with CFR 0.152.
 */
package sk.alloy_smelter.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import sk.alloy_smelter.recipe.CustomRecipeWrapper;

public class SmeltingRecipe
implements Recipe<CustomRecipeWrapper> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final int smeltingTime;
    private final int fuelPerTick;
    private final int requiredTier;

    public SmeltingRecipe(ResourceLocation id, NonNullList<Ingredient> inputItems, ItemStack output, int smeltingTime, int fuelPerTick, int requiredTier) {
        this.id = id;
        this.inputItems = inputItems;
        this.output = output;
        this.smeltingTime = smeltingTime;
        this.fuelPerTick = fuelPerTick;
        this.requiredTier = requiredTier;
    }

    public int getSmeltingTime() {
        return this.smeltingTime;
    }

    public int fuelPerTick() {
        return this.fuelPerTick;
    }

    public int getRequiredTier() {
        return this.requiredTier;
    }

    public ItemStack getOutput() {
        return this.m_8043_(null);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output.m_41777_();
    }

    public ItemStack assemble(CustomRecipeWrapper recipeWrapper, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean matches(CustomRecipeWrapper recipeWrapper, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 5; ++j) {
            ItemStack itemstack = recipeWrapper.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return recipeWrapper.getTier() == this.getRequiredTier() && i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null;
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<SmeltingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("alloy_smelter", "smelting");

        public SmeltingRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList<Ingredient> inputItems = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (inputItems.isEmpty()) {
                throw new JsonParseException("No ingredients for recipe");
            }
            if (inputItems.size() > 5) {
                throw new JsonParseException("Too many ingredients for recipe! The max is 5");
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            int smeltingTime = GsonHelper.m_13824_((JsonObject)json, (String)"smeltingTime", (int)200);
            int fuelPerTick = GsonHelper.m_13824_((JsonObject)json, (String)"fuelPerTick", (int)1);
            int requiredTier = GsonHelper.m_13824_((JsonObject)json, (String)"requiredTier", (int)1);
            return new SmeltingRecipe(id, inputItems, output, smeltingTime, fuelPerTick, requiredTier);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                JsonObject jsonIngredient = ingredientArray.get(i).getAsJsonObject();
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonIngredient);
                int count = 1;
                if (jsonIngredient.has("count")) {
                    count = GsonHelper.m_13927_((JsonObject)jsonIngredient, (String)"count");
                }
                ingredient.m_43908_()[0].m_41764_(count);
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public SmeltingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList inputItems = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputItems.size(); ++j) {
                inputItems.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int smeltingTime = buffer.m_130242_();
            int fuelPerTick = buffer.m_130242_();
            int requiredTier = buffer.m_130242_();
            return new SmeltingRecipe(id, (NonNullList<Ingredient>)inputItems, output, smeltingTime, fuelPerTick, requiredTier);
        }

        public void toNetwork(FriendlyByteBuf buffer, SmeltingRecipe recipe) {
            buffer.m_130130_(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130130_(recipe.smeltingTime);
            buffer.m_130130_(recipe.fuelPerTick);
            buffer.m_130130_(recipe.requiredTier);
        }
    }

    public static class Type
    implements RecipeType<SmeltingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "smelting";
    }
}

